﻿// $Id$

#include <assert.h>
#include <ccc/base/Spooler.h>
#include <ccc/base/Conveyer.h>
#include <ccc/base/FixedMemIFlow.h>

// ------------------------------------------------------------------------
// class Spooler

CCC_NAMESPACE_START(CCC);

Spooler::Spooler(IOType my_io_type, IOType dest_io_type, OFlow* dest)
  : OFilter(my_io_type, dest_io_type, dest),
    ifilters(dest_io_type, my_io_type, 0),
    spool_mem(),
    spool(&spool_mem)
{
}

Spooler::~Spooler()
{
}

bool
Spooler::rewind()
{
  spool.rewind();
  return OFilter::rewind();
}

void
Spooler::flush() CCC_RAISES(IOException)
{
  OFlow* dest = getDest();
  if (!dest)
  {
    throw IOException(__FILE__, __LINE__, IOException::EMPTY_FILTER_DEST);
  }
  FixedMemIFlow src(&spool_mem);
  ifilters.setSrc(&src);
  Conveyer conv(&ifilters, dest);
  try
  {
    conv.carry();
    spool.rewind();
    dest->flush();
  }
  catch (IOException ios)
  {
    if ((ios.errorNum() == IOException::READ_BEYOND_THE_EOF) ||
	(ios.errorNum() == IOException::NOT_OPENED))
    {
      return;
    }
    throw ios;
  }
}

bool
Spooler::validCombinationP()
{
  FixedMemIFlow src(&spool_mem);
  ifilters.setSrc(&src);
  if (!ifilters.validCombinationP())
  {
    return false;
  }
  return OFilter::validCombinationP();
}

void
Spooler::putInt8(Int8 c) CCC_RAISES(IOException)
{
  if (!getDest())
  {
    throw IOException(__FILE__, __LINE__, IOException::EMPTY_FILTER_DEST);
  }
  spool.putInt8(c);
  setTopP(false);
}

void
Spooler::putUInt16(UInt16 c) CCC_RAISES(IOException)
{
  if (!getDest())
  {
    throw IOException(__FILE__, __LINE__, IOException::EMPTY_FILTER_DEST);
  }
  spool.putUInt16(c);
  setTopP(false);
}

void
Spooler::putUInt32(UInt32 c) CCC_RAISES(IOException)
{
  if (!getDest())
  {
    throw IOException(__FILE__, __LINE__, IOException::EMPTY_FILTER_DEST);
  }
  spool.putUInt32(c);
  setTopP(false);
}

void
Spooler::putInt8Block(Size block_size, const Int8* ptr, Size& put_size) CCC_RAISES(IOException)
{
  if (!getDest())
  {
    throw IOException(__FILE__, __LINE__, IOException::EMPTY_FILTER_DEST);
  }
  spool.putInt8Block(block_size, ptr, put_size);
  setTopP(false);
}

void
Spooler::putUInt16Block(Size block_size, const UInt16* ptr, Size& put_size) CCC_RAISES(IOException)
{
  if (!getDest())
  {
    throw IOException(__FILE__, __LINE__, IOException::EMPTY_FILTER_DEST);
  }
  spool.putUInt16Block(block_size, ptr, put_size);
  setTopP(false);
}

void
Spooler::putUInt32Block(Size block_size, const UInt32* ptr, Size& put_size) CCC_RAISES(IOException)
{
  if (!getDest())
  {
    throw IOException(__FILE__, __LINE__, IOException::EMPTY_FILTER_DEST);
  }
  spool.putUInt32Block(block_size, ptr, put_size);
  setTopP(false);
}

void
Spooler::add(IFilter* filter)
{
  ifilters.add(filter);
}

#if 0
Iterator<IFilter>*
Spooler::createIterator()
{
  return ifilters.createIterator();
}
#endif

CCC_NAMESPACE_END(CCC);
