﻿// $Id$

#ifndef INCLUDE_ccc_base_Spooler_h
#define INCLUDE_ccc_base_Spooler_h

#include <ccc/base/OFilter.h>
#include <ccc/base/MemOFlow.h>
#include <ccc/base/CompositIFilter.h>

CCC_NAMESPACE_START(CCC)

/*!
 * Spooler
 */
class Spooler
  : public OFilter
{
  /*!
   * フィルタ
   */
  CompositIFilter ifilters;
  /*!
   * スプール用メモリ
   */
  Allocator spool_mem;
  /*!
   * スプール用出力メモリフロー
   */
  MemOFlow spool;
 public:
  /*!
   * \ja
   * コンストラクタ
   * \param my_io_type このフィルタの入力がサポートする型
   * \param dest_io_type フィルタの出力がサポートする型
   * \param dest フィルタ先OFlow
   * \ja_end
   */
  Spooler(IOType my_io_type, IOType dest_io_type, OFlow* dest = 0);
  /*!
   * \ja
   * デストラクタ
   * \ja_end
   */
  virtual ~Spooler();
  /*!
   * \ja
   * このフィルタを初期状態にし、フィルタ先に対してもrewind()を呼び出して
   * その結果を返します。
   * \retval true 成功
   * \retval false 失敗
   * \ja_end
   */
  virtual bool rewind();
  /*!
   * \ja
   * バッファリング中のデータを出力に完全に書出します。
   * \ja_end
   */
  virtual void flush() CCC_RAISES(IOException);
  /*!
   * \ja
   * フィルタ先とフィルタの出力が前提とする型が合致するかを
   * フィルタのチェーンをたどり再帰的に調べます。
   * \retval true 合致する
   * \retval false 合致しない
   * \ja_end
   */
  virtual bool validCombinationP();
  /*!
   * \ja
   * Int8のデータを出力します。
   * \param c 出力するデータ
   * \exception IOException
   * \ja_end
   */
  virtual void putInt8(Int8 c) CCC_RAISES(IOException);
  /*!
   * \ja
   * UInt16 のデータを出力します。
   * \param c 出力するデータ
   * \exception IOException
   * \ja_end
   */
  virtual void putUInt16(UInt16 c) CCC_RAISES(IOException);
  /*!
   * \ja
   * UInt32 のデータを出力します。
   * \param c 出力するデータ
   * \exception IOException
   * \ja_end
   */
  virtual void putUInt32(UInt32 c) CCC_RAISES(IOException);
  /*!
   * \ja
   * Int8のデータブロックを出力します。
   * put_sizeに出力したデータ数がセットされます。
   * \param block_size ブロックサイズ
   * \param ptr データの送り元
   * \param put_size 出力したデータ数
   * \ja_end
   */
  virtual void putInt8Block(Size block_size, const Int8* ptr, Size& put_size) CCC_RAISES(IOException);
  /*!
   * \ja
   * UInt16のデータブロックを出力します。
   * put_sizeに出力したデータ数がセットされます。
   * \param block_size ブロックサイズ
   * \param ptr データの送り元
   * \param put_size 出力したデータ数
   * \ja_end
   */
  virtual void putUInt16Block(Size block_size, const UInt16* ptr, Size& put_size) CCC_RAISES(IOException);
  /*!
   * \ja
   * UInt32のデータブロックを出力します。
   * put_sizeに出力したデータ数がセットされます。
   * \param block_size ブロックサイズ
   * \param ptr データの送り元
   * \param put_size 出力したデータ数
   * \ja_end
   */
  virtual void putUInt32Block(Size block_size, const UInt32* ptr, Size& put_size) CCC_RAISES(IOException);

  /* ConpositIFilterに対するインターフェース */
  /*!
   * \ja
   * IFilterのフィルタを追加します。
   * フィルタは追加した順番に実行されます。
   * 追加したフィルタは、デストラクタによってオブジェクトが破棄されます。
   * \param filter 追加するフィルタ
   * \ja_end
   */
  virtual void add(IFilter* filter);
#if 0
  /*
   * NOTE:
   * デストラクタでCompositIFilterに登録されているIFilter
   * を破棄するように仕様を変更したため、このメソッドは廃止しました。
   * このcreateIterator()メソッドを使用している箇所の
   * ソースコードは変更する必要があります。
   * 2006/1/21 Kudou
   */
  /*!
   * \ja
   * 登録したIFilterのリストに対するイタレータを返します。
   * 登録フィルタのメモリを破棄する場合には、このイタレータを使って
   * 登録したフィルタのアドレスを取り出してdeleteしてください。
   * イタレータを使い終わったらdeleteにより削除してください。
   * \return イタレータ
   * \ja_end
   */
  //Iterator<IFilter>* createIterator();
#endif
};

CCC_NAMESPACE_END(CCC)

#endif /* INCLUDE_ccc_base_Spooler_h */
