﻿// $Id$

#include <ccc/base/StringIFlow.h>

CCC_NAMESPACE_START(CCC)

template <typename T>
void
StringIFlow<T>::setSrc(const TString<T>* str)
{
  if (str)
  {
    top = str->getStartPtr();
    len = str->getLength();
    current = 0;
    setOpened(true);
  }
  else
  {
    top = 0;
    len = 0;
    current = 0;
    setOpened(false);
  }
}

template <typename T>
StringIFlow<T>::StringIFlow(const TString<T>* str)
  : IFlow(ioTypeVal<T>())
{
  setSrc(str);
}

template <typename T>
StringIFlow<T>::~StringIFlow()
{
}

template <typename T>
bool
StringIFlow<T>::openedP()
{
  return (top != 0);
}

template <typename T>
bool
StringIFlow<T>::topP()
{
  if (top == 0)
  {
    return false;
  }
  return current == 0;
}

template <typename T>
bool
StringIFlow<T>::close()
{
  if (top == 0)
  {
    return false;
  }
  top = 0;
  len = 0;
  current = 0;
  return false;
}

template <typename T>
bool
StringIFlow<T>::rewind()
{
  if (top == 0)
  {
    return false;
  }
  current = 0;
  return true;
}

// template <>
// Int8
// StringIFlow<Int8>::getInt8() CCC_RAISES(IOException);

// template <>
// UInt16
// StringIFlow<UInt16>::getUInt16() CCC_RAISES(IOException);

// template <>
// UInt32
// StringIFlow<UInt32>::getUInt32() CCC_RAISES(IOException);

template <>
Int8
StringIFlow<Int8>::getInt8() CCC_RAISES(IOException)
{
  if (top == 0)
  {
    throw IOException(__FILE__, __LINE__, IOException::NOT_OPENED);
  }
  if (current >= len)
  {
    throw IOException(__FILE__, __LINE__, IOException::READ_BEYOND_THE_EOF);
  }
  Int8 c = *(top + current++);
  return c;
}

template <>
UInt16
StringIFlow<UInt16>::getUInt16() CCC_RAISES(IOException)
{
  if (top == 0)
  {
    throw IOException(__FILE__, __LINE__, IOException::NOT_OPENED);
  }
  if (current >= len)
  {
    throw IOException(__FILE__, __LINE__, IOException::READ_BEYOND_THE_EOF);
  }
  UInt16 c = *(top + current++);
  return c;
}

template <>
UInt32
StringIFlow<UInt32>::getUInt32() CCC_RAISES(IOException)
{
  if (top == 0)
  {
    throw IOException(__FILE__, __LINE__, IOException::NOT_OPENED);
  }
  if (current >= len)
  {
    throw IOException(__FILE__, __LINE__, IOException::READ_BEYOND_THE_EOF);
  }
  UInt32 c = *(top + current++);
  return c;
}

template <typename T>
Int8
StringIFlow<T>::getInt8() CCC_RAISES(IOException)
{
  throw IOException(__FILE__, __LINE__, IOException::NOT_SUPPORTED);
  return 0;
}

template <typename T>
UInt16
StringIFlow<T>::getUInt16() CCC_RAISES(IOException)
{
  throw IOException(__FILE__, __LINE__, IOException::NOT_SUPPORTED);
  return 0;
}

template <typename T>
UInt32
StringIFlow<T>::getUInt32() CCC_RAISES(IOException)
{
  throw IOException(__FILE__, __LINE__, IOException::NOT_SUPPORTED);
  return 0;
}

template class StringIFlow<Int8>;
template class StringIFlow<UInt16>;
template class StringIFlow<UInt32>;

CCC_NAMESPACE_END(CCC)
