﻿// $Id$

#ifndef INCLUDE_ccc_base_StringIFlow_h
#define INCLUDE_ccc_base_StringIFlow_h

#include <ccc/base/IFlow.h>
#include <ccc/base/TString.h>

CCC_NAMESPACE_START(CCC)

/*!
 * \ja
 * 文字列からデータを入力するフロー
 * テンプレートで指定するInt8, UInt16, UInt32のいずれかの型の入力をサポートします。
 * \ja_end
 */
template <typename T>
class StringIFlow
  : public IFlow
{
  /*!
   * 対象文字列の先頭アドレス
   */
  T* top;
  /*!
   * 対象文字列の長さ
   */
  Size len;
  /*!
   * 現在走査中の位置
   */
  Size current;

 public:
  /*!
   * \ja
   * コンストラクタ<br>
   * strに0が指定されるとオープンされません。
   * \param str 入力対象とする文字列
   * \ja_end
   */
  StringIFlow(const TString<T>* str = 0);
  /*!
   * \ja
   * デストラクタ
   * \ja_end
   */
  ~StringIFlow();
  /*!
   * \ja
   * 入力対象の文字列をセットします。
   * strに0が指定されるとオープンされません。
   * \param str 入力対象とする文字列
   * \ja_end
   */
  void setSrc(const TString<T>* str);
  /*!
   * \ja
   * Flowのドキュメントを参照して下さい。
   * \ja_end
   */
  virtual bool openedP();
  /*!
   * \ja
   * Flowのドキュメントを参照して下さい。
   * \ja_end
   */
  virtual bool topP();
  /*!
   * \ja
   * Flowのドキュメントを参照して下さい。
   * \ja_end
   */
  virtual bool close();
  /*!
   * \ja
   * Flowのドキュメントを参照して下さい。
   * \ja_end
   */
  virtual bool rewind();
  /*!
   * \ja
   * IFlowのドキュメントを参照して下さい。
   * \ja_end
   */
  virtual Int8 getInt8() CCC_RAISES(IOException);
  /*!
   * \ja
   * IFlowのドキュメントを参照して下さい。
   * \ja_end
   */
  virtual UInt16 getUInt16() CCC_RAISES(IOException);
  /*!
   * \ja
   * IFlowのドキュメントを参照して下さい。
   * \ja_end
   */
  virtual UInt32 getUInt32() CCC_RAISES(IOException);
};

typedef StringIFlow<Int8> BStringIFlow;
typedef StringIFlow<UInt16> DStringIFlow;
typedef StringIFlow<UInt32> WStringIFlow;

CCC_NAMESPACE_END(CCC)

#endif /* INCLUDE_ccc_base_StringIFlow_h */
