﻿// $Id$

#include <ccc/base/StringOFlow.h>

CCC_NAMESPACE_START(CCC)

template <typename T>
StringOFlow<T>::StringOFlow(TString<T>* str)
  : OFlow(ioTypeVal<T>())
{
  dest = 0;
  setDest(str);
}

template <typename T>
StringOFlow<T>::~StringOFlow()
{
}

template <typename T>
void
StringOFlow<T>::setDest(TString<T>* str)
{
  dest = str;
  setOpened(!!str);
}

template <typename T>
bool
StringOFlow<T>::openedP()
{
  return !!dest;
}

template <typename T>
bool
StringOFlow<T>::topP()
{
  if (!dest)
  {
    return false;
  }
  return dest->getLength() == 0;
}

template <typename T>
bool
StringOFlow<T>::close()
{
  if (!dest)
  {
    return false;
  }
  dest = 0;
  setOpened(false);
  return true;
}

template <typename T>
bool
StringOFlow<T>::rewind()
{
  if (!openedP())
  {
    return false;
  }
  dest->clear();
  return true;
}

template <typename T>
Size
StringOFlow<T>::getSize()
{
  if (!openedP())
  {
    return 0;
  }
  return dest->getLength();
}

// template <>
// void
// StringOFlow<Int8>::putInt8(Int8 c) CCC_RAISES(IOException);

// template <>
// void
// StringOFlow<UInt16>::putUInt16(UInt16 c) CCC_RAISES(IOException);

// template <>
// void
// StringOFlow<UInt32>::putUInt32(UInt32 c) CCC_RAISES(IOException);

template <>
void
StringOFlow<Int8>::putInt8(Int8 c) CCC_RAISES(IOException)
{
  if (!openedP())
  {
    throw IOException(__FILE__, __LINE__, IOException::NOT_OPENED);
  }
  dest->add(c);
}

template <>
void
StringOFlow<UInt16>::putUInt16(UInt16 c) CCC_RAISES(IOException)
{
  if (!openedP())
  {
    throw IOException(__FILE__, __LINE__, IOException::NOT_OPENED);
  }
  dest->add(c);
}

template <>
void
StringOFlow<UInt32>::putUInt32(UInt32 c) CCC_RAISES(IOException)
{
  if (!openedP())
  {
    throw IOException(__FILE__, __LINE__, IOException::NOT_OPENED);
  }
  dest->add(c);
}

template <typename T>
void
StringOFlow<T>::putInt8(Int8 c) CCC_RAISES(IOException)
{
  throw IOException(__FILE__, __LINE__, IOException::NOT_SUPPORTED);
}

template <typename T>
void
StringOFlow<T>::putUInt16(UInt16 c) CCC_RAISES(IOException)
{
  throw IOException(__FILE__, __LINE__, IOException::NOT_SUPPORTED);
}

template <typename T>
void
StringOFlow<T>::putUInt32(UInt32 c) CCC_RAISES(IOException)
{
  throw IOException(__FILE__, __LINE__, IOException::NOT_SUPPORTED);
}

template class StringOFlow<Int8>;
template class StringOFlow<UInt16>;
template class StringOFlow<UInt32>;

CCC_NAMESPACE_END(CCC)
