﻿// $Id$

#ifndef INCLUDE_ccc_base_StringOFlow_h
#define INCLUDE_ccc_base_StringOFlow_h

#include <ccc/base/OFlow.h>
#include <ccc/base/TString.h>

CCC_NAMESPACE_START(CCC)

/*!
 * \ja
 * 文字列にデータを出力するフロー
 * テンプレートで指定するInt8, UInt16, UInt32のいずれかの型の出力をサポートします。
 * \ja_end
 */
template <typename T>
class StringOFlow
  : public OFlow
{
  TString<T>* dest;

 public:
  /*!
   * \ja
   * コンストラクタ
   * \param str 出力先の文字列を指定します。
   * \ja_end
   */
  StringOFlow(TString<T>* str = 0);
  /*!
   * \ja
   * デストラクタ
   * \ja_end
   */
  ~StringOFlow();
  /*!
   * \ja
   * 出力対象の文字列をセットします。
   * strに0が指定されるとオープンされません。
   * \param str 出力先の文字列
   * \ja_end
   */
  void setDest(TString<T>* str);
  /*!
   * \ja
   * Flowのドキュメントを参照して下さい。
   * \ja_end
   */
  virtual bool openedP();
  /*!
   * \ja
   * Flowのドキュメントを参照して下さい。
   * \ja_end
   */
  virtual bool topP();
  /*!
   * \ja
   * Flowのドキュメントを参照して下さい。
   * \ja_end
   */
  virtual bool close();
  /*!
   * \ja
   * Flowのドキュメントを参照して下さい。
   * \ja_end
   */
  virtual bool rewind();
  /*!
   * \ja
   * Flowのドキュメントを参照して下さい。
   * \ja_end
   */
  virtual void putInt8(Int8 c) CCC_RAISES(IOException);
  /*!
   * \ja
   * Flowのドキュメントを参照して下さい。
   * \ja_end
   */
  virtual void putUInt16(UInt16 c) CCC_RAISES(IOException);
  /*!
   * \ja
   * Flowのドキュメントを参照して下さい。
   * \ja_end
   */
  virtual void putUInt32(UInt32 c) CCC_RAISES(IOException);
  /*!
   * \ja
   * 出力先文字列のサイズを得ます。
   * \return 文字列のサイズ
   * \ja_end
   */
  virtual Size getSize();
};

typedef StringOFlow<Int8> BStringOFlow;
typedef StringOFlow<UInt16> DStringOFlow;
typedef StringOFlow<UInt32> WStringOFlow;

CCC_NAMESPACE_END(CCC)

#endif /* INCLUDE_ccc_base_StringOFlow_h */
