﻿// $Id$

#ifndef INCLUDE_ccc_base_TFixedMemIFlow_h
#define INCLUDE_ccc_base_TFixedMemIFlow_h

#include <ccc/base/FixedMemIFlow.h>

CCC_NAMESPACE_START(CCC)

/*!
 * \ja
 * メモリ入力フロー
 * テンプレートで指定したInt8, UInt16, UInt32のいずれかの型に関する
 * 入力のみをサポートします。機能的にはFixedMemIFlowと同じですが、
 * 明示的に特定の型のみによるメモリ入力フローを実現するために使用します。
 * \ja_end
 */
template <typename T>
class TFixedMemIFlow
  : public FixedMemIFlow
{
 public:
  /*!
   * \ja
   * コンストラクタ<br>
   * フローはオープンされません。
   * \ja_end
   */
  TFixedMemIFlow()
    : FixedMemIFlow()
  {
    setIOType(ioTypeVal<T>());
  }
  /*!
   * \ja
   * コンストラクタ<br>
   * memとsizeが0でなければフローをオープンします。
   * sizeにはバイト数ではなく、T型のメモリがいくつ連なっているかを指定します。
   * \param mem メモリの先頭アドレス
   * \param size サイズ
   * \ja_end
   */
  TFixedMemIFlow(T* mem, Size size)
    : FixedMemIFlow((void*)mem, size * sizeof(T))
  {
    setIOType(ioTypeVal<T>());
  }
  /*!
   * 入力元のメモリとサイズをセットしフローをオープンします。
   * sizeにはバイト数ではなく、T型のメモリがいくつ連なっているかを指定します。
   * memとsizeが0でなければフローをオープンします。
   * \param mem メモリの先頭アドレス
   * \param size サイズ
   */
  void set(T* mem, Size size)
  {
    FixedMemIFlow::set((void*)mem, size * sizeof(T));
  }
  /*!
   * \ja
   * IFlowのドキュメントを参照して下さい。
   * \ja_end
   */
  virtual Int8 getInt8() CCC_RAISES(IOException);
  /*!
   * \ja
   * IFlowのドキュメントを参照して下さい。
   * \ja_end
   */
  virtual UInt16 getUInt16() CCC_RAISES(IOException);
  /*!
   * \ja
   * IFlowのドキュメントを参照して下さい。
   * \ja_end
   */
  virtual UInt32 getUInt32() CCC_RAISES(IOException);
};

CCC_NAMESPACE_END(CCC)

#endif /* INCLUDE_ccc_base_TFixedMemIFlow_h */
