﻿// $Id$

#ifndef INCLUDE_ccc_base_TFixedMemOFlow_h
#define INCLUDE_ccc_base_TFixedMemOFlow_h

#include <ccc/base/FixedMemOFlow.h>

CCC_NAMESPACE_START(CCC)

/*!
 * \ja
 * メモリ出力フロー
 * テンプレートで指定したInt8, UInt16, UInt32のいずれかの型に関する
 * 出力のみをサポートします。機能的にはFixedMemOFlowと同じですが、
 * 明示的に特定の型のみによるメモリ出力フローを実現するために使用します。
 * \ja_end
 */
template <typename T>
class TFixedMemOFlow
  : public FixedMemOFlow
{
 public:	
  /*!
   * \ja
   * コンストラクタ<br>
   * フローはオープンされません。
   * \ja_end
   */
  TFixedMemOFlow()
    : FixedMemOFlow()
  {
    setIOType(ioTypeVal<T>());
  }
  /*!
   * \ja
   * コンストラクタ<br>
   * フローがオープンされます。
   * sizeにはバイト数ではなく、T型のメモリがいくつ連なっているかを指定します。
   * memとsizeが0でなければフローをオープンします。
   * \param mem メモリの先頭アドレス
   * \param size サイズ
   * \ja_end
   */
  TFixedMemOFlow(T* mem, Size size)
    : FixedMemOFlow((void*)mem, size * sizeof(T))
  {
    setIOType(ioTypeVal<T>());
  }
  /*!
   * 出力先のメモリとサイズをセットしフローをオープンします。
   * sizeにはバイト数ではなく、T型のメモリがいくつ連なっているかを指定します。
   * memとsizeが0でなければフローをオープンします。
   * \param mem メモリの先頭アドレス
   * \param size サイズ
   */
  void set(T* mem, Size size)
  {
    FixedMemOFlow::set((void*)mem, size * sizeof(T));
  }
  /*!
   * \ja
   * OFlowのドキュメントを参照して下さい。
   * \ja_end
   */
  virtual void putInt8(Int8 c) CCC_RAISES(IOException);
  /*!
   * \ja
   * OFlowのドキュメントを参照して下さい。
   * \ja_end
   */
  virtual void putUInt16(UInt16 c) CCC_RAISES(IOException);
  /*!
   * \ja
   * OFlowのドキュメントを参照して下さい。
   * \ja_end
   */
  virtual void putUInt32(UInt32 c) CCC_RAISES(IOException);
};

CCC_NAMESPACE_END(CCC)

#endif /* INCLUDE_ccc_base_TFixedMemOFlow_h */
