﻿// $Id$

#include <ccc/base/TIFilter.h>

CCC_NAMESPACE_START(CCC)

template <typename T>
TIFilter<T>::TIFilter(IOType src_io_type, IFlow* src)
  : IFilter(ioTypeVal<T>(), src_io_type, src)
{
}

template <typename T>
TIFilter<T>::~TIFilter()
{
}

template <>
Int8
TIFilter<Int8>::getInt8() CCC_RAISES(IOException)
{
  return IFilter::getInt8();
}

template <>
UInt16
TIFilter<UInt16>::getUInt16() CCC_RAISES(IOException)
{
  return IFilter::getUInt16();
}

template <>
UInt32
TIFilter<UInt32>::getUInt32() CCC_RAISES(IOException)
{
  return IFilter::getUInt32();
}

template <>
void
TIFilter<Int8>::getInt8Block(Size block_size, Int8* ptr, Size& get_size) CCC_RAISES(IOException)
{
  IFilter::getInt8Block(block_size, ptr, get_size);
}

template <>
void
TIFilter<UInt16>::getUInt16Block(Size block_size, UInt16* ptr, Size& get_size) CCC_RAISES(IOException)
{
  IFilter::getUInt16Block(block_size, ptr, get_size);
}

template <>
void
TIFilter<UInt32>::getUInt32Block(Size block_size, UInt32* ptr, Size& get_size) CCC_RAISES(IOException)
{
  IFilter::getUInt32Block(block_size, ptr, get_size);
}

template <>
Int8
TIFilter<Int8>::getChar() CCC_RAISES(IOException)
{
  return IFilter::getInt8();
}

template <>
UInt16
TIFilter<UInt16>::getChar() CCC_RAISES(IOException)
{
  return IFilter::getUInt16();
}

template <>
UInt32
TIFilter<UInt32>::getChar() CCC_RAISES(IOException)
{
  return IFilter::getUInt32();
}

template <>
void
TIFilter<Int8>::getBlock(Size block_size, Int8* ptr, Size& get_size) CCC_RAISES(IOException)
{
  IFilter::getInt8Block(block_size, ptr, get_size);
}

template <>
void
TIFilter<UInt16>::getBlock(Size block_size, UInt16* ptr, Size& get_size) CCC_RAISES(IOException)
{
  IFilter::getUInt16Block(block_size, ptr, get_size);
}

template <>
void
TIFilter<UInt32>::getBlock(Size block_size, UInt32* ptr, Size& get_size) CCC_RAISES(IOException)
{
  IFilter::getUInt32Block(block_size, ptr, get_size);
}

template <typename T>
Int8
TIFilter<T>::getInt8() CCC_RAISES(IOException)
{
  throw IOException(__FILE__, __LINE__, IOException::NOT_SUPPORTED);
  return 0;
}

template <typename T>
UInt16
TIFilter<T>::getUInt16() CCC_RAISES(IOException)
{
  throw IOException(__FILE__, __LINE__, IOException::NOT_SUPPORTED);
  return 0;
}

template <typename T>
UInt32
TIFilter<T>::getUInt32() CCC_RAISES(IOException)
{
  throw IOException(__FILE__, __LINE__, IOException::NOT_SUPPORTED);
  return 0;
}

template <typename T>
void
TIFilter<T>::getInt8Block(Size block_size, Int8* ptr, Size& get_size) CCC_RAISES(IOException)
{
  throw IOException(__FILE__, __LINE__, IOException::NOT_SUPPORTED);
}

template <typename T>
void
TIFilter<T>::getUInt16Block(Size block_size, UInt16* ptr, Size& get_size) CCC_RAISES(IOException)
{
  throw IOException(__FILE__, __LINE__, IOException::NOT_SUPPORTED);
}

template <typename T>
void
TIFilter<T>::getUInt32Block(Size block_size, UInt32* ptr, Size& get_size) CCC_RAISES(IOException)
{
  throw IOException(__FILE__, __LINE__, IOException::NOT_SUPPORTED);
}

template <typename T>
T
TIFilter<T>::getChar() CCC_RAISES(IOException)
{
  throw IOException(__FILE__, __LINE__, IOException::NOT_SUPPORTED);
  return 0;
}

template <typename T>
void
TIFilter<T>::getBlock(Size block_size, T* ptr, Size& get_size) CCC_RAISES(IOException)
{
  throw IOException(__FILE__, __LINE__, IOException::NOT_SUPPORTED);
}

template class TIFilter<Int8>;
template class TIFilter<UInt16>;
template class TIFilter<UInt32>;

CCC_NAMESPACE_END(CCC)
