﻿// $Id$

#ifndef INCLUDE_ccc_base_TIFilter_h
#define INCLUDE_ccc_base_TIFilter_h

#include <ccc/base/IFilter.h>

CCC_NAMESPACE_START(CCC)

/*!
 * \ja
 * 入力用フィルタ
 * 各入力用フィルタ用クラスの継承元となるクラスです。
 * IFilterと比べてテンプレート引数で指定した型以外の入力を
 * 行うと例外を発生させることができる点が異なります。
 * テンプレート引数TはInt8, UInt16, UInt32のいずれかの型のみを
 * サポートします。
 * \ja_end
 */
template <typename T>
class TIFilter
  : public IFilter
{
 public:
  /*!
   * \ja
   * コンストラクタ
   * \param src_io_type フィルタの入力フローがサポートすべき型
   * \param src フィルタ元IFlow
   * \ja_end
   */
  TIFilter(IOType src_io_type, IFlow* src = 0);
  /*!
   * \ja
   * デストラクタ
   * \ja_end
   */
  virtual ~TIFilter();
  /*!
   * \ja
   * IFlowクラスのドキュメントを参照して下さい。
   * \ja_end
   */
  virtual Int8 getInt8() CCC_RAISES(IOException);
  /*!
   * \ja
   * IFlowクラスのドキュメントを参照して下さい。
   * \ja_end
   */
  virtual UInt16 getUInt16() CCC_RAISES(IOException);
  /*!
   * \ja
   * IFlowクラスのドキュメントを参照して下さい。
   * \ja_end
   */
  virtual UInt32 getUInt32() CCC_RAISES(IOException);
  /*!
   * \ja
   * Int8のデータブロックを取り出します。
   * get_sizeに読み込めたデータ数がセットされます。
   * \param block_size ブロックサイズ
   * \param ptr データの保存先
   * \param get_size 読み込んだデータ数
   * \ja_end
   */
  virtual void getInt8Block(Size block_size, Int8* ptr, Size& get_size) CCC_RAISES(IOException);
  /*!
   * \ja
   * UInt16のデータブロックを取り出します。
   * get_sizeに読み込めたデータ数がセットされます。
   * \param block_size ブロックサイズ
   * \param ptr データの保存先
   * \param get_size 読み込んだデータ数
   * \ja_end
   */
  virtual void getUInt16Block(Size block_size, UInt16* ptr, Size& get_size) CCC_RAISES(IOException);
  /*!
   * \ja
   * UInt32のデータブロックを取り出します。
   * get_sizeに読み込めたデータ数がセットされます。
   * \param block_size ブロックサイズ
   * \param ptr データの保存先
   * \param get_size 読み込んだデータ数
   * \ja_end
   */
  virtual void getUInt32Block(Size block_size, UInt32* ptr, Size& get_size) CCC_RAISES(IOException);
  /*!
   * \ja
   * T型のデータを読み込みます。
   * \ja_end
   */
  virtual T getChar() CCC_RAISES(IOException);
  /*!
   * \ja
   * T型のデータブロックを読み込みます。
   * \param block_size ブロックサイズ
   * \param ptr データの保存先
   * \param get_size 読み込んだデータ数
   * \ja_end
   */
  virtual void getBlock(Size block_size, T* ptr, Size& get_size) CCC_RAISES(IOException);
};

CCC_NAMESPACE_END(CCC)

#endif /* INCLUDE_ccc_base_TIFilter_h */
