﻿// $Id$

#include <ccc/base/TMemOFlow.h>

CCC_NAMESPACE_START(CCC)

template <typename T>
TMemOFlow<T>::TMemOFlow()
  : MemOFlow()
{
  setIOType(ioTypeVal<T>());
}

//template <typename T>
//TMemOFlow<T>::TMemOFlow(T* mem, Size size)
//  : MemOFlow((void*)mem, size * sizeof(T))
//{
//  setIOType(ioTypeVal<T>());
//}

template <>
void
TMemOFlow<Int8>::putInt8(Int8 c) CCC_RAISES(IOException)
{
  MemOFlow::putInt8(c);
}

template <>
void
TMemOFlow<UInt16>::putUInt16(UInt16 c) CCC_RAISES(IOException)
{
  MemOFlow::putUInt16(c);
}

template <>
void
TMemOFlow<UInt32>::putUInt32(UInt32 c) CCC_RAISES(IOException)
{
  MemOFlow::putUInt32(c);
}

template <typename T>
void
TMemOFlow<T>::putInt8(Int8 c) CCC_RAISES(IOException)
{
  throw IOException(__FILE__, __LINE__, IOException::NOT_SUPPORTED);
}

template <typename T>
void
TMemOFlow<T>::putUInt16(UInt16 c) CCC_RAISES(IOException)
{
  throw IOException(__FILE__, __LINE__, IOException::NOT_SUPPORTED);
}

template <typename T>
void
TMemOFlow<T>::putUInt32(UInt32 c) CCC_RAISES(IOException)
{
  throw IOException(__FILE__, __LINE__, IOException::NOT_SUPPORTED);
}

template class TMemOFlow<Int8>;
template class TMemOFlow<UInt16>;
template class TMemOFlow<UInt32>;

CCC_NAMESPACE_END(CCC);
