﻿// $Id$

#ifndef INCLUDE_ccc_base_TMemOFlow_h
#define INCLUDE_ccc_base_TMemOFlow_h

#include <ccc/base/MemOFlow.h>

CCC_NAMESPACE_START(CCC)

/*!
 * \ja
 * メモリサイズが自動拡張されるメモリ出力フロー
 * テンプレートで指定したInt8, UInt16, UInt32のいずれかの型に関する
 * 出力のみをサポートします。機能的にはMemOFlowと同じですが、
 * 明示的に特定の型のみによるメモリ出力フローを実現するために使用します。
 * \ja_end
 */
template <typename T>
class TMemOFlow
  : public MemOFlow
{
 public:	
  /*!
   * \ja
   * コンストラクタ<br>
   * フローはオープンされません。
   * \ja_end
   */
  TMemOFlow();
  /*!
   * \ja
   * コンストラクタ<br>
   * フローがオープンされます。
   * sizeにはバイト数ではなく、T型のメモリがいくつ連なっているかを指定します。
   * memとsizeが0でなければフローをオープンします。
   * \param mem メモリの先頭アドレス
   * \param size サイズ
   * \ja_end
   */
  //TMemOFlow(T* mem, Size size);
  /*!
   * \ja
   * OFlowのドキュメントを参照して下さい。
   * \ja_end
   */
  virtual void putInt8(Int8 c) CCC_RAISES(IOException);
  /*!
   * \ja
   * OFlowのドキュメントを参照して下さい。
   * \ja_end
   */
  virtual void putUInt16(UInt16 c) CCC_RAISES(IOException);
  /*!
   * \ja
   * OFlowのドキュメントを参照して下さい。
   * \ja_end
   */
  virtual void putUInt32(UInt32 c) CCC_RAISES(IOException);
  /*!
   * \ja
   * 使用したメモリサイズを取得します。
   * フローを閉じた後でも取得できます。
   * バイト数ではなく、T型のメモリがいくつ連なっているかが返ります。
   * \return メモリサイズ
   * \ja_end
   */
  Size getSize()
  {
    return MemOFlow::getSize() / sizeof(T);
  }
  /*!
   * \ja
   * メモリの先頭アドレスを取得します。
   * フローを閉じた後は0が返ります。
   * \return メモリ先頭アドレス
   * \ja_end
   */
  T* getTMem()
  {
    return (T*)MemOFlow::getMem();
  }
};

CCC_NAMESPACE_END(CCC)

#endif /* INCLUDE_ccc_base_TMemOFlow_h */
