﻿// $Id$

#include <ccc/base/TOFilter.h>

CCC_NAMESPACE_START(CCC)

template <typename T>
TOFilter<T>::TOFilter(IOType dest_io_type, OFlow* dest)
  : OFilter(ioTypeVal<T>(), dest_io_type, dest)
{
}

template <typename T>
TOFilter<T>::~TOFilter()
{
}

template <>
void
TOFilter<Int8>::putInt8(Int8 c) CCC_RAISES(IOException)
{
  OFilter::putInt8(c);
}

template <>
void
TOFilter<UInt16>::putUInt16(UInt16 c) CCC_RAISES(IOException)
{
  OFilter::putUInt16(c);
}

template <>
void
TOFilter<UInt32>::putUInt32(UInt32 c) CCC_RAISES(IOException)
{
  OFilter::putUInt32(c);
}

template <>
void
TOFilter<Int8>::putInt8Block(Size block_size, const Int8* ptr, Size& put_size) CCC_RAISES(IOException)
{
  OFilter::putInt8Block(block_size, ptr, put_size);
}

template <>
void
TOFilter<UInt16>::putUInt16Block(Size block_size, const UInt16* ptr, Size& put_size) CCC_RAISES(IOException)
{
  OFilter::putUInt16Block(block_size, ptr, put_size);
}

template <>
void
TOFilter<UInt32>::putUInt32Block(Size block_size, const UInt32* ptr, Size& put_size) CCC_RAISES(IOException)
{
  OFilter::putUInt32Block(block_size, ptr, put_size);
}

template <>
void
TOFilter<Int8>::putChar(Int8 c) CCC_RAISES(IOException)
{
  OFilter::putInt8(c);
}

template <>
void
TOFilter<UInt16>::putChar(UInt16 c) CCC_RAISES(IOException)
{
  OFilter::putUInt16(c);
}

template <>
void
TOFilter<UInt32>::putChar(UInt32 c) CCC_RAISES(IOException)
{
  OFilter::putUInt32(c);
}

template <>
void
TOFilter<Int8>::putBlock(Size block_size, const Int8* ptr, Size& put_size) CCC_RAISES(IOException)
{
  OFilter::putInt8Block(block_size, ptr, put_size);
}

template <>
void
TOFilter<UInt16>::putBlock(Size block_size, const UInt16* ptr, Size& put_size) CCC_RAISES(IOException)
{
  OFilter::putUInt16Block(block_size, ptr, put_size);
}

template <>
void
TOFilter<UInt32>::putBlock(Size block_size, const UInt32* ptr, Size& put_size) CCC_RAISES(IOException)
{
  OFilter::putUInt32Block(block_size, ptr, put_size);
}

template <typename T>
void
TOFilter<T>::putInt8(Int8 c) CCC_RAISES(IOException)
{
  throw IOException(__FILE__, __LINE__, IOException::NOT_SUPPORTED);
}

template <typename T>
void
TOFilter<T>::putUInt16(UInt16 c) CCC_RAISES(IOException)
{
  throw IOException(__FILE__, __LINE__, IOException::NOT_SUPPORTED);
}

template <typename T>
void
TOFilter<T>::putUInt32(UInt32 c) CCC_RAISES(IOException)
{
  throw IOException(__FILE__, __LINE__, IOException::NOT_SUPPORTED);
}

template <typename T>
void
TOFilter<T>::putInt8Block(Size block_size, const Int8* ptr, Size& put_size) CCC_RAISES(IOException)
{
  throw IOException(__FILE__, __LINE__, IOException::NOT_SUPPORTED);
}

template <typename T>
void
TOFilter<T>::putUInt16Block(Size block_size, const UInt16* ptr, Size& put_size) CCC_RAISES(IOException)
{
  throw IOException(__FILE__, __LINE__, IOException::NOT_SUPPORTED);
}

template <typename T>
void
TOFilter<T>::putUInt32Block(Size block_size, const UInt32* ptr, Size& put_size) CCC_RAISES(IOException)
{
  throw IOException(__FILE__, __LINE__, IOException::NOT_SUPPORTED);
}

template <typename T>
void
TOFilter<T>::putChar(T c) CCC_RAISES(IOException)
{
  throw IOException(__FILE__, __LINE__, IOException::NOT_SUPPORTED);
}

template <typename T>
void
TOFilter<T>::putBlock(Size block_size, const T* ptr, Size& put_size) CCC_RAISES(IOException)
{
  throw IOException(__FILE__, __LINE__, IOException::NOT_SUPPORTED);
}

template class TOFilter<Int8>;
template class TOFilter<UInt16>;
template class TOFilter<UInt32>;

CCC_NAMESPACE_END(CCC);
