﻿// $Id$

#ifndef INCLUDE_ccc_base_TOFilter_h
#define INCLUDE_ccc_base_TOFilter_h

#include <ccc/base/OFilter.h>

CCC_NAMESPACE_START(CCC)

/*!
 * \ja
 * 出力用フィルタ
 * 各入力用フィルタ用クラスの継承元となるクラスです。
 * OFilterと比べてテンプレート引数で指定した型以外の出力を
 * 行うと例外を発生させることができる点が異なります。
 * テンプレート引数TはInt8, UInt16, UInt32のいずれかの型のみを
 * サポートします。
 * \ja_end
 */
template <typename T>
class TOFilter
  : public OFilter
{
 public:
  /*!
   * \ja
   * コンストラクタ
   * \param dest_io_type フィルタの出力がサポートする型
   * \param dest フィルタ先OFlow
   * \ja_end
   */
  TOFilter(IOType dest_io_type, OFlow* dest = 0);
  /*!
   * \ja
   * デストラクタ
   * \ja_end
   */
  virtual ~TOFilter();
  /*!
   * \ja
   * Int8のデータを出力します。
   * \param c 出力するデータ
   * \exception IOException
   * \ja_end
   */
  virtual void putInt8(Int8 c) CCC_RAISES(IOException);
  /*!
   * \ja
   * UInt16 のデータを出力します。
   * \param c 出力するデータ
   * \exception IOException
   * \ja_end
   */
  virtual void putUInt16(UInt16 c) CCC_RAISES(IOException);
  /*!
   * \ja
   * UInt32 のデータを出力します。
   * \param c 出力するデータ
   * \exception IOException
   * \ja_end
   */
  virtual void putUInt32(UInt32 c) CCC_RAISES(IOException);
  /*!
   * \ja
   * Int8のデータブロックを出力します。
   * put_sizeに出力したデータ数がセットされます。
   * \param block_size ブロックサイズ
   * \param ptr データの送り元
   * \param put_size 出力したデータ数
   * \ja_end
   */
  virtual void putInt8Block(Size block_size, const Int8* ptr, Size& put_size) CCC_RAISES(IOException);
  /*!
   * \ja
   * UInt16のデータブロックを出力します。
   * put_sizeに出力したデータ数がセットされます。
   * \param block_size ブロックサイズ
   * \param ptr データの送り元
   * \param put_size 出力したデータ数
   * \ja_end
   */
  virtual void putUInt16Block(Size block_size, const UInt16* ptr, Size& put_size) CCC_RAISES(IOException);
  /*!
   * \ja
   * UInt32のデータブロックを出力します。
   * put_sizeに出力したデータ数がセットされます。
   * \param block_size ブロックサイズ
   * \param ptr データの送り元
   * \param put_size 出力したデータ数
   * \ja_end
   */
  virtual void putUInt32Block(Size block_size, const UInt32* ptr, Size& put_size) CCC_RAISES(IOException);
  /*!
   * TODO: UNITTEST
   * \ja
   * T型のデータを出力します。
   * \param c 出力するデータ
   * \exception IOException
   * \ja_end
   */
  virtual void putChar(T c) CCC_RAISES(IOException);
  /*!
   * \ja
   * T型のデータブロックを出力します。
   * \param block_size ブロックサイズ
   * \param ptr データの送り元
   * \param put_size 出力したデータ数
   * \ja_end
   */
  virtual void putBlock(Size block_size, const T* ptr, Size& put_size) CCC_RAISES(IOException);
};

CCC_NAMESPACE_END(CCC)

#endif /* INCLUDE_ccc_base_TOFilter_h */
