﻿// $Id$

#include <ccc/base/TStringPtr.h>
#include <ccc/base/TString.h>

CCC_NAMESPACE_START(CCC)

template <typename T>
TStringPtr<T>::TStringPtr()
{
  str = (TString<T>*)this;
  pos = 0;
}

template <typename T>
TStringPtr<T>::TStringPtr(const TStringPtr<T>& sp, Size pos)
{
  str = sp.str;
  TStringPtr::pos = pos;
}

template <typename T>
TStringPtr<T>::TStringPtr(const TStringPtr<T>& sp)
{
  str = sp.str;
  pos = sp.pos;
} 

template <typename T>
TStringPtr<T>::TStringPtr(TString<T>* str, Size pos)
{
  TStringPtr<T>::str = str;
  TStringPtr<T>::pos = pos;
}

template <typename T>
TStringPtr<T>::~TStringPtr()
{
  ; // do nothing
}

template <typename T> Size
TStringPtr<T>::getPos() const
{
  return pos;
}

template <typename T> T*
TStringPtr<T>::getStartPtr() const
{
  return str->getStartPtr() + pos;
}

template <typename T> T&
TStringPtr<T>::operator [] (Size n) const
{
  return *(str->getStartPtr() + pos + n);
}

template <typename T> T
TStringPtr<T>::getChar() const
{
  return pointsToACharacterP() ? *getStartPtr() : 0;
}

template <typename T> bool
TStringPtr<T>::pointsToACharacterP() const
{
  return pos < str->getLength();
}

template class TStringPtr<Int8>;
template class TStringPtr<UInt8>;
template class TStringPtr<UInt16>;
template class TStringPtr<UInt32>;

CCC_NAMESPACE_END(CCC)
