﻿// $Id$

#ifndef INCLUDE_ccc_base_TStringPtr_h
#define INCLUDE_ccc_base_TStringPtr_h

#include <ccc/base/base.h>

CCC_NAMESPACE_START(CCC)

template <typename T> class TString;
template <typename T> class TSubString;

/*!
 * \ja
 * \brief このクラスはString\<T\>の文字列内の位置を指し示すために使用します。
 * \ja_end
 * \en
 * \brief This class points a position of the String\<T\> string.
 * \en_end
 */
template <typename T>
class TStringPtr
  : Object
{
 protected:
  /*!
   * \ja
   * 対象の文字列
   * \ja_end
   * \en
   * target string
   * \en_end
   */
  TString<T>* str;
  /*!
   * \ja
   * 文字列の先頭を0として数えた位置
   * \ja_end
   * \en
   * position, from 0 coordination
   * \en_end
   */
  Size pos;
  /*!
   * \ja
   * SubStringのコンストラクタのためのコンストラクタ
   * \ja_end
   * \en
   * A constructor for the SubString constructor.
   * \en_end
   */
  TStringPtr();

 public:
  /*!
   * \ja
   * コンストラクタ
   * \param sp 対象文字列を指しているStringPtr
   * \param pos 0から数えた位置
   * \ja_end
   */
  TStringPtr(const TStringPtr& sp, Size pos);
  /*!
   * \ja
   * コピーコンストラクタ
   * \param sp 文字列の位置
   * \ja_end
   */
  TStringPtr(const TStringPtr& sp);
  /*!
   * \ja
   * コンストラクタ
   * \param str 指し示す対象の文字列
   * \param pos 0から数えた位置
   * \ja_end
   */
  TStringPtr(TString<T>* str, Size pos = 0);
  /*!
   * \ja
   * デストラクタ
   * \ja_end
   */
  virtual ~TStringPtr();
  /*!
   * \ja
   * 該当位置の文字へのポインタを得ます。
   * \return 該当位置の文字へのポインタ
   * \ja_end
   */
  virtual T* getStartPtr() const;
  /*!
   * \ja
   * 位置を得る
   * \return 位置
   * \ja_end
   */
  virtual Size getPos() const;
  /*!
   * \ja
   * []オペレータ、このオブジェクトが示す位置を先頭とする、
   * 配列の参照形式のインターフェースを提供します。
   * 文字の参照を返します。
   * \param n 位置
   * \return 文字の参照
   * \ja_end
   */
  virtual T& operator [] (Size n) const;
  /*!
   * \ja
   * 対象の文字列の参照を返します。
   * \return 文字列の参照
   * \ja_end
   */
  TString<T>& getStr() const { return *str; }
  /*!
   * \ja
   * 対象文字列の対象位置の値を返します。
   * \return 文字の値
   * \ja_end
   */
  T getChar() const;
  /*!
   * \ja
   * オブジェクトが文字の存在する位置を指しているかどうかを調べます。
   * 参照している文字列が存在し、位置が文字列の内部ならば真を返します。
   * (以前のバージョンでは、このメソッドはvalidP()という名前でした。)
   * \retval true 文字を指している
   * \retval false 文字を指していない
   * \ja_end
   */
  bool pointsToACharacterP() const;
};

typedef TStringPtr<char> BStringPtr;
typedef TStringPtr<UInt16> DStringPtr;
typedef TStringPtr<UInt32> WStringPtr;

CCC_NAMESPACE_END(CCC)

#endif /* INCLUDE_ccc_base_TStringPtr_h */
