﻿// $Id$

#include <ccc/base/TSubStringIterator.h>

CCC_NAMESPACE_START(CCC)

template <typename T> 
TSubStringIterator<T>::TSubStringIterator(const TSubString<T>& ss_)
 : ss(ss_)
{
  if (ss.getLength() > 0)
  {
    pos = 1;
  }
  else
  {
    pos = 0;
  }
}

template <typename T>
bool
TSubStringIterator<T>::validPositionP() const
{
  if ((pos >= 1) &&
      (pos <= ss.getLength()))
  {
    return true;
  }
  return false;
}

template <typename T>
T*
TSubStringIterator<T>::current() const
{
  if (validPositionP())
  {
    return &(ss.getStartPtr()[pos - 1]);
  }
  else
  {
    return 0;
  }
}

template <typename T>
T*
TSubStringIterator<T>::next()
{
  if (validPositionP())
  {
    return &ss.getStartPtr()[pos++ - 1];
  }
  else
  {
    return 0;
  }
}

template <typename T>
T*
TSubStringIterator<T>::prev()
{
  if (validPositionP())
  {
    return &ss.getStartPtr()[pos-- - 1];
  }
  else
  {
    return 0;
  }
}

template <typename T>
T*
TSubStringIterator<T>::rewind()
{
  if (ss.getLength() > 0)
  {
    pos = 1;
    return &ss.getStartPtr()[0];
  }
  else
  {
    pos = 0;
    return 0;
  }
}

template <typename T>
T*
TSubStringIterator<T>::unwind()
{
  if (ss.getLength() > 0)
  {
    pos = ss.getLength();
    return &ss.getStartPtr()[pos - 1];
  }
  else
  {
    pos = 0;
    return 0;
  }
}

template <typename T>
TStringPtr<T>
TSubStringIterator<T>::getStrPtr()
{
  if (validPositionP())
  {
    return TStringPtr<T>(ss, pos - 1);
  }
  else
  {
    return TStringPtr<T>(ss);
  }
}

template class TSubStringIterator<Int8>;
template class TSubStringIterator<UInt8>;
template class TSubStringIterator<UInt16>;
template class TSubStringIterator<UInt32>;

CCC_NAMESPACE_END(CCC)
