﻿// $Id$

#ifndef INCLUDE_ccc_base_TSubStringIterator_h
#define INCLUDE_ccc_base_TSubStringIterator_h

#include <ccc/base/Iterator.h>
#include <ccc/base/TSubString.h>

CCC_NAMESPACE_START(CCC)

/*!
 * \ja
 * このクラスは部分文字列のイタレータ機能を提供します。
 * イタレーション中に部分文字列の長さが変化することは想定されていません。
 * \ja_end
 * \en
 * This class provides function of substring iterator.
 * \en_end
 */
template <typename T>
class TSubStringIterator
  : public Iterator<T>
{
  /*!
   * \ja
   * イタレーション対象の部分文字列
   * \ja_end
   * \en
   * iteration sub string
   * \en_end
   */
  const TSubString<T>& ss;
  /*!
   * \ja
   * 現在のイタレーション位置、1からss.getLength()の範囲
   * \ja_end
   * \en
   * current iteration position. between 1 and ss.getLength()
   * \en_end
   */
  Size pos;
   
 public:
  /*!
   * \ja
   * コンストラクタ
   * \param _ss 対象の部分文字列
   * \ja_end
   */
  TSubStringIterator(const TSubString<T>& _ss);
  /*!
   * \ja
   * 現在のポイント位置の文字へのポインタを返します。
   * 0が返った場合には現在範囲外を指し示していることを意味します。
   * \return 現在のポイント位置の文字へのポインタ
   * \ja_end
   */
  T* current() const;
  /*!
   * \ja
   * 現在のポイント位置を一つ進めます。
   * 0が返った場合には範囲外を指し示していることを意味します。
   * \return ポイント位置の文字へのポインタ
   * \ja_end
   */
  T* next();
  /*!
   * \ja
   * 現在のポイント位置を一つ戻します。
   * 0が返った場合には範囲外を指し示していることを意味します。
   * \return ポイント位置の文字へのポインタ
   * \ja_end
   */
  T* prev();
  /*!
   * \ja
   * ポイント位置を先頭に移動します。
   * 0が返った場合には範囲外を指し示していることを意味します。
   * \return ポイント位置の文字へのポインタ
   * \ja_end
   */
  T* rewind();
  /*!
   * \ja
   * ポイント位置を文字列の最後に移動します。
   * 0が返った場合には範囲外を指し示していることを意味します。
   * \return ポイント位置の文字へのポインタ
   * \ja_end
   */
  T* unwind();
  /*!
   * \ja
   * ポイント位置が対象の部分文字列の範囲内かどうかを調べます。
   * \retval true 範囲内
   * \retval false 範囲外
   * \ja_end
   */
  bool validPositionP() const;
  /*!
   * \ja
   * 現在のポイント位置のStringPtr&lt;T&gt;を生成します。
   * \ja_end
   */
  TStringPtr<T> getStrPtr();
  /*!
   * \ja
   * 現在のポイント位置を得ます。
   * \return ポイント位置
   * \ja_end
   */
  Size getPosition() const { return pos; }
};

typedef TSubStringIterator<char> BSubStringIterator;
typedef TSubStringIterator<UInt16> DSubStringIterator;
typedef TSubStringIterator<UInt32> WSubStringIterator;

CCC_NAMESPACE_END(CCC)

#endif /* INCLUDE_ccc_base_TSubStringIterator_h */
