﻿// $Id$

#include <stdarg.h>
#include <ccc/base/TextWriter.h>
#include <ccc/base/TextReader.h>
#include <ccc/base/StringIFlow.h>
#include <ccc/base/cstring.h>

CCC_NAMESPACE_START(CCC)

template <typename T>
void
TextWriter<T>::putBlock(Size block_size, const T* ptr, Size& put_size) CCC_RAISES(IOException)
{
#if 1
  TOFilter<T>::putBlock(block_size, ptr, put_size);
#else
  put_size = 0;
  while (block_size > 0)
  {
    putChar(*ptr++);
    block_size--;
    put_size++;
  }
#endif
}

template <typename T>
void
TextWriter<T>::print(const TString<T>* s) CCC_RAISES(IOException)
{
  Size len = s->getLength();
  T* ptr = s->getStartPtr();
  Size put_size;
  putBlock(len, ptr, put_size);
}

template <typename T>
void
TextWriter<T>::print(const TString<T>& s) CCC_RAISES(IOException)
{
  Size len = s.getLength();
  T* ptr = s.getStartPtr();
  Size put_size;
  putBlock(len, ptr, put_size);
}

template <typename T>
void
TextWriter<T>::print(const T* s) CCC_RAISES(IOException)
{
  Size len = strLen(s);
  Size put_size;
  putBlock(len, s, put_size);
}

template <typename T>
void
TextWriter<T>::print(const T* s, Size len) CCC_RAISES(IOException)
{
  Size put_size;
  putBlock(len, s, put_size);
}

template <typename T>
Size
TextWriter<T>::write(bool clear_p)
{
  TString<T>* s = Formatter<T>::makeString(clear_p);
  Size len = s->getLength();
  print(s);
  delete s;
  return len;
}

template <typename T>
Size
TextWriter<T>::printf(const TString<T>* fmt, ...) CCC_RAISES(IOException)
{
  va_list arg;
  va_start(arg, fmt);
  Size len = vprintf(fmt, arg);
  va_end(arg);
  return len;
}

template <typename T>
Size
TextWriter<T>::printf(const T* fmt, ...) CCC_RAISES(IOException)
{
  va_list arg;
  va_start(arg, fmt);
  Size len = vprintf(fmt, arg);
  va_end(arg);
  return len;
}

template <typename T>
Size
TextWriter<T>::printf(Size len, const T* fmt, ...) CCC_RAISES(IOException)
{
  va_list arg;
  va_start(arg, fmt);
  Size ret = vprintf(len, fmt, arg);
  va_end(arg);
  return ret;
}

template <typename T>
Size
TextWriter<T>::vprintf(const T* fmt, va_list arg) CCC_RAISES(IOException)
{
  TString<T> fmt_str(fmt);
  return vprintf(&fmt_str, arg);
}

template <typename T>
Size
TextWriter<T>::vprintf(Size len, const T* fmt, va_list arg) CCC_RAISES(IOException)
{
  TString<T> fmt_str(fmt, len);
  return vprintf(&fmt_str, arg);
}

template <typename T>
Size
TextWriter<T>::vprintf(const TString<T>* fmt, va_list arg) CCC_RAISES(IOException)
{
  T num[] =
  {
    (T)'0', (T)'1', (T)'2', (T)'3', (T)'4', (T)'5', (T)'6', (T)'7', (T)'8', (T)'9', 0
  };
  StringIFlow<T> si(fmt);
  TextReader<T> reader(&si);
  try
  {
    int argn = 1;
    for (;;)
    {
      T c = reader.getChar();
      if (c == (T)'%')
      {
	/* 構文解析 */
	// %[&argn][-][+][ ][0][#][width][.precision]type
	TString<T>* x;
	//Size len;
	if (reader.readChar((T)'{'))
	{
	  x = reader.skipCandidates(num);
	  delete x;
	  reader.readChar((T)'}');
	}
	reader.readChar((T)'-');
	reader.readChar((T)'+');
	reader.readChar((T)' ');
	reader.readChar((T)'0');
	reader.readChar((T)'#');
	if (reader.readChar((T)'*'))
	{
	  // int
	  argn++;
	  Formatter<T>::setArg((int)va_arg(arg, int));
	}
	else
	{
	  x = reader.skipCandidates(num);
	  delete x;
	}
	if (reader.readChar((T)'.'))
	{
	  if (reader.readChar((T)'*'))
	  {
	    // int
	    argn++;
	    Formatter<T>::setArg((int)va_arg(arg, int));
	  }
	  else
	  {
	    x = reader.skipCandidates(num);
	    delete x;
	  }
	}
	c = reader.getChar();
	if (c > (T)0x7e)
	{
	  /* 不正な変換指定子 */
	  return 0;
	  //throw FmtException(__FILE__, __LINE__, FmtException::INVALID_FORMAT_SPECIFIER);
	}
	/* 出力の生成 */
	switch (c)
	{
	 case 'd':
	 case 'i':
	  Formatter<T>::setArg((int)va_arg(arg, int));
	  break;
	 case 'o':
	 case 'x':
	 case 'X':
	 case 'u':
	  Formatter<T>::setArg((unsigned int)va_arg(arg, unsigned int));
	  break;
	 case 'c':
	  Formatter<T>::setArg((int)va_arg(arg, int));
	  break;
	 case 's':
	  Formatter<T>::setArg((T*)va_arg(arg, T*));
	  break;
	 case 'f':
	 case 'e':
	 case 'E':
	 case 'g':
	 case 'G':
	  Formatter<T>::setArg((double)va_arg(arg, double));
	  break;
	 case 'p':
	  Formatter<T>::setArg((void*)va_arg(arg, void*));
	  break;
	 case 'n':
	  Formatter<T>::setArg((int*)va_arg(arg, int*));
	  break;
	 case '%':
	  break;
	 default:	/* 不正な変換指定子 */
	  return 0;
	  //throw FmtException(__FILE__, __LINE__, FmtException::INVALID_FORMAT_SPECIFIER);
	  break;
	}
      }
    }
  }
  catch (IOException ioe)
  {
    if (ioe.errorNum() != IOException::READ_BEYOND_THE_EOF)
    {
      throw ioe;
    }
  }
  this->setFormat(fmt);
  TString<T>* result = Formatter<T>::makeString(true);
  Size len = result->getLength();
  print(result);
  delete result;
  return len;
}

template class TextWriter<Int8>;
template class TextWriter<UInt16>;
template class TextWriter<UInt32>;

TextWriter<Int8>* stdout_w8 = 0;
TextWriter<UInt16>* stdout_w16 = 0;
TextWriter<UInt32>* stdout_w32 = 0;
TextWriter<Int8>* stderr_w8 = 0;
TextWriter<UInt16>* stderr_w16 = 0;
TextWriter<UInt32>* stderr_w32 = 0;
TextWriter<Int8>* nulout_w8 = 0;
TextWriter<UInt16>* nulout_w16 = 0;
TextWriter<UInt32>* nulout_w32 = 0;

CCC_NAMESPACE_END(CCC)
