﻿// $Id$

#ifndef INCLUDE_ccc_base_TextWriter_h
#define INCLUDE_ccc_base_TextWriter_h

#include <stdarg.h>
#include <ccc/base/TOFilter.h>
#include <ccc/base/Formatter.h>

CCC_NAMESPACE_START(CCC)

/*! 
 * TextWriterクラスはフローに対する出力フィルタとして動作し、
 * テキストの出力インターフェースを提供します。
 * テンプレート引数TはInt8, UInt16, UInt32のいずれかの型のみを
 * サポートします。
 */
template <typename T>
class TextWriter
  : public TOFilter<T>,
    public Formatter<T>
{
 public:
  /*!
   * コンストラクタ
   * \param dest 出力先フロー
   */
  TextWriter(OFlow* dest = 0)
    : TOFilter<T>(ioTypeVal<T>(), dest) { }
  /*!
   * デストラクタ
   */
  ~TextWriter() { }
  // ------------------------------------------------------------
  /* 単位データ出力 */
  /*!
   * T型の値を出力します。
   * \param c 出力するデータ
   */
  //virtual void putChar(T c) CCC_RAISES(IOException);
  /*!
   * TODO: UNITTEST
   *
   * 指定した数のデータを出力します。
   * \param block_size 出力サイズ
   * \param ptr 出力データの内容
   * \param put_size 出力したデータ数
   */
  virtual void putBlock(Size block_size, const T* ptr, Size& put_size) CCC_RAISES(IOException);
  // ------------------------------------------------------------
  /* 文字列出力 */
  /*!
   * TODO: UNITTEST<br>
   * 文字列の内容を出力します。
   * \param s 出力内容
   */
  virtual void print(const TString<T>* s) CCC_RAISES(IOException);
  /*!
   * TODO: UNITTEST<br>
   * 文字列の内容を出力します。
   * \param s 出力内容
   */
  virtual void print(const TString<T>& s) CCC_RAISES(IOException);
  /*!
   * TODO: UNITTEST<br>
   * ヌル終端の文字列の内容を出力します。
   * \param s 出力内容
   */
  virtual void print(const T* s) CCC_RAISES(IOException);
  /*!
   * TODO: UNITTEST<br>
   * 文字列の内容を出力します。
   * \param s 出力内容
   * \param len 文字列の長さ
   */
  virtual void print(const T* s, Size len) CCC_RAISES(IOException);
  // ------------------------------------------------------------
  /* Formatterインターフェース */
  /*!
   * TODO: UNITTEST<br>
   * フォーマット結果を出力します。
   * フォーマット文字列の設定や引数の設定にはFormatterクラスのメソッドを使用してください。
   * \param clear_p trueを指定すると出力後にFormatterの書式と引数情報をクリアします。
   * \return 出力した文字数
   */
  Size write(bool clear_p = true);
  // ------------------------------------------------------------
  /* 書式付きデータ出力
   * このインターフェースは引数の型チェック機能が無いため、利用をお勧めしません。
   * Formatterインターフェースの利用をお勧めします。
   */
  /*!
   * TODO: UNITTEST<br>
   * 書式付きデータ出力を行ないます。書式の仕様はANSI Cのprintfの書式仕様に従います。
   * \param fmt 書式
   * \return 出力した文字数
   */
  virtual Size printf(const TString<T>* fmt, ...) CCC_RAISES(IOException);
  /*!
   * TODO: UNITTEST<br>
   * 書式付きデータ出力を行ないます。書式の仕様はANSI Cのprintfの書式仕様に従います。
   * \param fmt 書式
   * \return 出力した文字数
   */
  virtual Size printf(const T* fmt, ...) CCC_RAISES(IOException);
  /*!
   * TODO: UNITTEST<br>
   * 書式付きデータ出力を行ないます。書式の仕様はANSI Cのprintfの書式仕様に従います。
   * \param len 書式文字列の長さ
   * \param fmt 書式
   * \return 出力した文字数
   */
  virtual Size printf(Size len, const T* fmt, ...) CCC_RAISES(IOException);
  /*!
   * TODO: UNITTEST<br>
   * 書式付きデータ出力を行ないます。書式の仕様はANSI Cのprintfの書式仕様に従います。
   * \param fmt 書式
   * \param arg 引き数
   * \return 出力した文字数
   */
  virtual Size vprintf(const TString<T>* fmt, va_list arg) CCC_RAISES(IOException);
  /*!
   * TODO: UNITTEST<br>
   * 書式付きデータ出力を行ないます。書式の仕様はANSI Cのprintfの書式仕様に従います。
   * \param fmt 書式
   * \param arg 引き数
   * \return 出力した文字数
   */
  virtual Size vprintf(const T* fmt, va_list arg) CCC_RAISES(IOException);
  /*!
   * TODO: UNITTEST<br>
   * 書式付きデータ出力を行ないます。書式の仕様はANSI Cのprintfの書式仕様に従います。
   * \param len 書式文字列の長さ
   * \param fmt 書式
   * \param arg 引き数
   * \return 出力した文字数
   */
  virtual Size vprintf(Size len, const T* fmt, va_list arg) CCC_RAISES(IOException);
};

typedef TextWriter<char> BTextWriter;
typedef TextWriter<UInt16> DTextWriter;
typedef TextWriter<UInt32> WTextWriter;

extern TextWriter<Int8>* stdout_w8;
extern TextWriter<UInt16>* stdout_w16;
extern TextWriter<UInt32>* stdout_w32;
extern TextWriter<Int8>* stderr_w8;
extern TextWriter<UInt16>* stderr_w16;
extern TextWriter<UInt32>* stderr_w32;
extern TextWriter<Int8>* nulout_w8;
extern TextWriter<UInt16>* nulout_w16;
extern TextWriter<UInt32>* nulout_w32;

CCC_NAMESPACE_END(CCC)

#endif /* INCLUDE_ccc_base_TextWriter_h */
