﻿// $Id$

#include <ccc/base/UInt16SwapEndianIFilter.h>

CCC_NAMESPACE_START(CCC)

UInt16SwapEndianIFilter::UInt16SwapEndianIFilter(IFlow* src)
  : IFilter(IOTYPE_UINT16, IOTYPE_UINT16, src)
{
}

UInt16SwapEndianIFilter::~UInt16SwapEndianIFilter()
{
}

UInt16
UInt16SwapEndianIFilter::getUInt16() CCC_RAISES(IOException)
{
  if (!openedP())
  {
    throw IOException(__FILE__, __LINE__, IOException::EMPTY_FILTER_SRC);
  }
  UInt16 c = swap_16(src->getUInt16());
  setTopP(false);
  return c;
}

CCC_NAMESPACE_END(CCC)
