﻿// $Id$

#ifndef INCLUDE_ccc_base_UInt16SwapEndianIFilter_h
#define INCLUDE_ccc_base_UInt16SwapEndianIFilter_h

#include <ccc/base/IFilter.h>

CCC_NAMESPACE_START(CCC)

/*!
 * \ja
 * Int16型の上位バイトと下位バイトを入れ換えるフィルタです。
 * \ja_end
 */
class UInt16SwapEndianIFilter
  : public IFilter
{
 public:
  /*!
   * \ja
   * コンストラクタ
   * \param src フィルタ元IFlow
   * \ja_end
   */
  UInt16SwapEndianIFilter(IFlow* src = 0);
  /*!
   * \ja
   * デストラクタ
   * \ja_end
   */
  virtual ~UInt16SwapEndianIFilter();
  /*!
   * \ja
   * IFlowのドキュメントを参照して下さい。
   * \ja_end
   */
  virtual UInt16 getUInt16() CCC_RAISES(IOException);
};

CCC_NAMESPACE_END(CCC)

#endif /* INCLUDE_ccc_base_UInt16SwapEndianIFilter_h */
