﻿// $Id$

#include <ccc/base/UInt32SwapEndianIFilter.h>

CCC_NAMESPACE_START(CCC)

UInt32SwapEndianIFilter::UInt32SwapEndianIFilter(IFlow* src)
  : IFilter(IOTYPE_UINT32, IOTYPE_UINT32, src)
{
}

UInt32SwapEndianIFilter::~UInt32SwapEndianIFilter()
{
}

UInt32
UInt32SwapEndianIFilter::getUInt32() CCC_RAISES(IOException)
{
  if (!openedP())
  {
    throw IOException(__FILE__, __LINE__, IOException::EMPTY_FILTER_SRC);
  }
  UInt32 c = src->getUInt32();
  setTopP(false);
  return swap_32(c);
}

CCC_NAMESPACE_END(CCC)
