﻿// $Id$

#include <ccc/base/ValIFlow.h>

CCC_NAMESPACE_START(CCC)

ValIFlow::ValIFlow(int val, int inc, IOType io_type)
  : IFlow(io_type)
{
  initial_val = val;
  increment = inc;
  current = val;
}

ValIFlow::~ValIFlow()
{
}

bool
ValIFlow::rewind()
{
  current = initial_val;
  return Flow::rewind();
}

Int8
ValIFlow::getInt8() CCC_RAISES(IOException)
{
  Int8 c = (Int8)current;
  current += increment;
  return c;
}

UInt16
ValIFlow::getUInt16() CCC_RAISES(IOException)
{
  UInt16 c = (UInt16)current;
  current += increment;
  return c;
}

UInt32
ValIFlow::getUInt32() CCC_RAISES(IOException)
{
  UInt32 c = (UInt32)current;
  current += increment;
  return c;
}

CCC_NAMESPACE_END(CCC)

