﻿// $Id$

#ifndef INCLUDE_ccc_base_ValIFlow_h
#define INCLUDE_ccc_base_ValIFlow_h

#include <ccc/base/IFlow.h>

CCC_NAMESPACE_START(CCC)

/*!
 * 特定の値を返す入力フローです。
 * 増分を指定した場合には、入力ごとに値が増加します。
 * 値はintで保持あるいは計算され、各入力の型にキャストした値が返ります。
 */
class ValIFlow
  : public IFlow
{
  /*!
   * 初期値
   */
  int initial_val;
  /*!
   * 増分
   */
  int increment;
  /*!
   * 現在の値
   */
  int current;
 public:
  /*!
   * \ja
   * コンストラクタ
   * \param io_type サポートする型
   * \param val 初期値
   * \param inc 増分
   * \ja_end
   */
  ValIFlow(int val = 0, int inc = 0, IOType io_type = IOTYPE_NULL);
  /*!
   * \ja
   * デストラクタ
   * \ja_end
   */
  virtual ~ValIFlow();
  /*!
   * \ja
   * フローの読み書き位置を先頭に巻き戻し、フローのステータスを初期状態に戻します。
   * \retval true 巻き戻し成功
   * \retval false 巻き戻し失敗
   * \ja_end
   */
  virtual bool rewind();
  /*!
   * \ja
   * Int8のデータを取り出します。
   * \return 取り出した値
   * \exception IOException
   * \ja_end
   */
  virtual Int8 getInt8() CCC_RAISES(IOException);
  /*!
   * \ja
   * UInt16のデータを取り出します。
   * \return 取り出した値
   * \exception IOException
   * \ja_end
   */
  virtual UInt16 getUInt16() CCC_RAISES(IOException);
  /*!
   * \ja
   * UInt32 のデータを取り出します。
   * \return 取り出した値
   * \exception IOException
   * \ja_end
   */
  virtual UInt32 getUInt32() CCC_RAISES(IOException);
};

CCC_NAMESPACE_END(CCC)

#endif /* INCLUDE_ccc_base_ValIFlow_h */
