﻿// $Id$

#ifndef INCLUDE_ccc_base_XList_h
#define INCLUDE_ccc_base_XList_h

// exogenous list

#include <ccc/base/List.h>

CCC_NAMESPACE_START(CCC)

template <class Element>
class XList			//! XList
  : public List<Element>
{
 public:
  XList() { }
  virtual ~XList() { };

  // Collection interface
  virtual bool emptyP() const = 0;
  virtual Size number() const = 0;
  virtual bool add(Element* element) = 0;
  virtual void clear() = 0;
  virtual Iterator<Element>* createIterator() const = 0;

  // List interface
  virtual Element* vector(Size vec_pos) const = 0;
  Element* operator [] (Size vec_pos) const { return vector(vec_pos); };
  virtual Element* access(Size pos) const { return vector(pos - 1); }
  virtual Size getPosition(Element* element) const = 0;
  virtual Element* prev(Element* element) const = 0;
  virtual Element* next(Element* element) const = 0;
  virtual Element* head() const = 0;
  virtual Element* tail() const = 0;
  virtual bool elementP(Element* element) const = 0;
  // single element operations
  virtual void push(Element* element) = 0;
  virtual Element* pop() = 0;
  virtual void inject(Element* element) = 0;
  virtual Element* eject() = 0;
  virtual bool insertBefore(Size pos, Element* element) = 0;
  virtual bool insertBefore(Element* pos, Element* element) = 0;
  virtual bool insertAfter(Size pos, Element* element) = 0;
  virtual bool insertAfter(Element* pos, Element* element) = 0;
  virtual bool remove(Element* pos) = 0;
  virtual bool remove(Size pos) = 0;
  virtual bool exchangeElement(Size pos, Element* element) = 0;
  virtual bool exchangeElement(Element* pos, Element* element) = 0;
  virtual bool swapElement(Element* i1, Element* i2) = 0;
  virtual bool swapElement(Size n1, Size n2) = 0;
  virtual bool removeAllBefore(Size pos) = 0;
  virtual bool removeAllBefore(Element* pos) = 0;
  virtual bool removeAllAfter(Size pos) = 0;
  virtual bool removeAllAfter(Element* pos) = 0;
  virtual bool removeAllBetween(Size pos1, Size pos2) = 0;
  virtual bool removeAllBetween(Element* pos1, Element* pos2) = 0;

  // multi elements operations
  virtual bool add(XList& l);
  virtual void assign(XList& l);
  void operator = (XList& l) { assign(l); };
  virtual void reverseAssign(XList& l);
  virtual bool removeElements(XList& l);
  virtual bool push(XList& l);
  virtual bool inject(XList& l);
  virtual bool insertBefore(Size pos, XList& l);
  virtual bool insertBefore(Element* pos, XList& l);
  virtual bool insertAfter(Size pos, XList& l);
  virtual bool insertAfter(Element* pos, XList& l);
  virtual bool add(XList& l, Size pos1, Size pos2);
  virtual bool assign(XList& l, Size pos1, Size pos2);
  virtual bool removeElements(XList& l, Size pos1, Size pos2);
  virtual bool push(XList& l, Size pos1, Size pos2);
  virtual bool inject(XList& l, Size pos1, Size pos2);
  virtual bool insertBefore(Size pos, XList& l, Size pos1, Size pos2);
  virtual bool insertBefore(Element* pos, XList& l, Size pos1, Size pos2);
  virtual bool insertAfter(Size pos, XList& l, Size pos1, Size pos2);
  virtual bool insertAfter(Element* pos, XList& l, Size pos1, Size pos2);
  /*!
   * delete all instance.
   */
  virtual void deleteAllItems();
};

// ------------------------------------------------------------
// class XList<Element> method

template <class Element>
bool
XList<Element>::add(XList& l)
{
  Iterator<Element>* li = l.createIterator();
  while (li->validPositionP())
  {
    inject(li->next());
  }
  delete li;
  return true;
}

template <class Element>
void
XList<Element>::assign(XList<Element>& l)
{
  clear();
  add(l);
}

template <class Element>
void
XList<Element>::reverseAssign(XList& l)
{
  clear();
  Iterator<Element>* li = l.createIterator();
  while (li->validPositionP())
  {
    push(li->next());
  }
  delete li;
}

template <class Element>
bool
XList<Element>::removeElements(XList& l)
{
  bool ret = true;
  Iterator<Element>* li = l.createIterator();
  while (li->validPositionP())
  {
    if (!remove(li->next()))
    {
      ret = false;
      break;
    }
  }
  delete li;
  return ret;
}

template <class Element>
bool
XList<Element>::push(XList& l)
{
  bool ret = true;
  Iterator<Element>* li = l.createIterator();
  Size n = 0;
  while (li->validPositionP())
  {
    if (n == 0)
    {
      push(li->next());
    }
    else
    {
      if (!insertAfter(n, li->next()))
      {
	ret = false;
	break;
      }
    }
    n++;
  }
  delete li;
  return ret;
}

template <class Element>
bool
XList<Element>::inject(XList& l)
{
  Iterator<Element>* li = l.createIterator();
  while (li->validPositionP())
  {
    inject(li->next());
  }
  delete li;
  return true;
}

template <class Element>
bool
XList<Element>::insertBefore(Size pos, XList& l)
{
  bool ret = true;
  Iterator<Element>* li = l.createIterator();
  while (li->validPositionP())
  {
    if (!insertBefore(pos++, li->next()))
    {
      ret = false;
      break;
    }
  }
  delete li;
  return ret;
}

template <class Element>
bool
XList<Element>::insertBefore(Element* e_pos, XList& l)
{
  Size pos = getPosition(e_pos);
  if (!pos)
  {
    return false;
  }
  return insertBefore(pos, l);
}

template <class Element>
bool
XList<Element>::insertAfter(Size pos, XList& l)
{
  bool ret = true;
  Iterator<Element>* li = l.createIterator();
  while (li->validPositionP())
  {
    if (!insertAfter(pos++, li->next()))
    {
      ret = false;
      break;
    }
  }
  delete li;
  return ret;
}

template <class Element>
bool
XList<Element>::insertAfter(Element* e_pos, XList& l)
{
  Size pos = getPosition(e_pos);
  if (!pos)
  {
    return false;
  }
  return insertAfter(pos, l);
}

template <class Element>
bool
XList<Element>::add(XList& l, Size pos1, Size pos2)
{
  if (!pos1 || !pos2)
  {
    return false;
  }
  Size beg_pos;
  Size end_pos;
  getBand(beg_pos, end_pos, pos1, pos2);
  Iterator<Element>* li = l.createIterator();
  Size n = 1;
  while (li->validPositionP() &&
	 n <= end_pos)
  {
    if (n >= beg_pos)
    {
      inject(li->current());
    }
    li->next();
    n++;
  }
  delete li;
  return true;
}

template <class Element>
bool
XList<Element>::assign(XList& l, Size pos1, Size pos2)
{
  clear();
  return add(l, pos1, pos2);
}

template <class Element>
bool
XList<Element>::removeElements(XList& l, Size pos1, Size pos2)
{
  if (!pos1 || !pos2)
  {
    return false;
  }
  Size beg_pos;
  Size end_pos;
  getBand(beg_pos, end_pos, pos1, pos2);
  bool ret = true;
  Iterator<Element>* li = l.createIterator();
  Size n = 1;
  while (li->validPositionP() &&
	 n <= end_pos)
  {
    if (n >= beg_pos)
    {
      if (!remove(li->current()))
      {
	ret = false;
	break;
      }
    }
    li->next();
    n++;
  }
  delete li;
  return ret;
}

template <class Element>
bool
XList<Element>::push(XList& l, Size pos1, Size pos2)
{
  if (!pos1 || !pos2)
  {
    return false;
  }
  Size beg_pos;
  Size end_pos;
  getBand(beg_pos, end_pos, pos1, pos2);
  bool ret = true;
  Iterator<Element>* li = l.createIterator();
  Size n = 1;
  Size i = 1;
  while (li->validPositionP() &&
	 n <= end_pos)
  {
    if (n == beg_pos)
    {
      push(li->current());
    }
    else if (n > beg_pos)
    {
      if (!insertAfter(i++, li->current()))
      {
	ret = false;
	break;
      }
    }
    li->next();
    n++;
  }
  delete li;
  return ret;
}

template <class Element>
bool
XList<Element>::inject(XList& l, Size pos1, Size pos2)
{
  if (!pos1 || !pos2)
  {
    return false;
  }
  Size beg_pos;
  Size end_pos;
  getBand(beg_pos, end_pos, pos1, pos2);
  bool ret = true;
  Iterator<Element>* li = l.createIterator();
  Size n = 1;
  while (li->validPositionP() &&
	 n <= end_pos)
  {
    if (n >= beg_pos)
    {
      inject(li->current());
    }
    li->next();
    n++;
  }
  delete li;
  return ret;
}

template <class Element>
bool
XList<Element>::insertBefore(Size pos, XList& l, Size pos1, Size pos2)
{
  if (!pos1 || !pos2)
  {
    return false;
  }
  Size beg_pos;
  Size end_pos;
  getBand(beg_pos, end_pos, pos1, pos2);
  bool ret = true;
  Iterator<Element>* li = l.createIterator();
  Size n = 1;
  while (li->validPositionP() &&
	 n <= end_pos)
  {
    if (n >= beg_pos)
    {
      if (!insertBefore(pos++, li->current()))
      {
	ret = false;
	break;
      }
    }
    li->next();
    n++;
  }
  delete li;
  return ret;
}

template <class Element>
bool
XList<Element>::insertBefore(Element* pos, XList& l, Size pos1, Size pos2)
{
  return insertBefore(getPosition(pos), l, pos1, pos2);
}

template <class Element>
bool
XList<Element>::insertAfter(Size pos, XList& l, Size pos1, Size pos2)
{
  if (!pos1 || !pos2)
  {
    return false;
  }
  Size beg_pos;
  Size end_pos;
  getBand(beg_pos, end_pos, pos1, pos2);
  bool ret = true;
  Iterator<Element>* li = l.createIterator();
  Size n = 1;
  while (li->validPositionP() &&
	 n <= end_pos)
  {
    if (n >= beg_pos)
    {
      if (!insertAfter(pos++, li->current()))
      {
	ret = false;
	break;
      }
    }
    li->next();
    n++;
  }
  delete li;
  return ret;
}

template <class Element>
bool
XList<Element>::insertAfter(Element* pos_e, XList& l, Size pos1, Size pos2)
{
  return insertAfter(getPosition(pos_e), l, pos1, pos2);
}

template <class Element>
void
XList<Element>::deleteAllItems()
{
  Iterator<Element>* li = createIterator();
  Element* element;
  while ((element = li->next()))
  {
    delete element;
  }
  delete li;
  clear();
}

CCC_NAMESPACE_END(CCC)

#endif /* INCLUDE_ccc_base_XList_h */
