﻿// $Id$

#ifndef INCLUDE_ccc_base_cstring_h
#define INCLUDE_ccc_base_cstring_h

#include <ctype.h>
#include <string.h>
#include <ccc/base/base.h>

CCC_NAMESPACE_START(CCC)

/*!
 * \ja
 * Tの文字型のヌル終端文字列の長さを得ます。
 * \param s ヌル終端文字列
 * \return 長さ
 * \ja_end
 */
template <typename T> Size
strLen(const T* s)
{
  Size n = 0;
  while (*s)
  {
    s++;
    n++;
  }
  return n;
}

/*!
 * \ja
 * Tの文字型のヌル終端文字列を比較します。
 * \param s1 比較するヌル終端文字列
 * \param s2 比較するヌル終端文字列
 * \retval 0 同一の内容
 * \retval 1 s1はs2より大きい
 * \retval -1 s1はs2より小さい
 * \ja_end
 */
template <typename T> int
strCmp(const T* s1, const T* s2)
{
  Size s1_len = strLen(s1);
  Size s2_len = strLen(s2);
  while (*s1 && *s2)
  {
    if (*s1 > *s2)
    {
      return 1;
    }
    else if (*s1 < *s2)
    {
      return -1;
    }
    s1++;
    s2++;
  }
  return (s1_len == s2_len) ? 0 : (s1_len > s2_len) ? 1 : -1;
}

/*!
 * \ja
 * 大文字小文字の区別なくTの文字型のヌル終端文字列を比較します。
 * \param s1 比較するヌル終端文字列
 * \param s2 比較するヌル終端文字列
 * \retval 0 同一の内容
 * \retval 1 s1はs2より大きい
 * \retval -1 s1はs2より小さい
 * \ja_end
 */
template <typename T> int
strNCaseCmp(const T* s1, const T* s2)
{
  Size s1_len = strLen(s1);
  Size s2_len = strLen(s2);
  while (*s1 && *s2)
  {
    T a = *s1++;
    T b = *s2++;
    if ((a <= 0xff) && isupper((char)a))
    {
      a = tolower(a);
    }
    if ((b <= 0xff) && isupper((char)b))
    {
      b = tolower(b);
    }
    if (a != b)
    {
      return a > b ? 1 : -1;
    }
  }
  return (s1_len == s2_len) ? 0 : (s1_len > s2_len) ? 1 : -1;
}

/*!
 * \ja
 * Tの文字型のメモリブロックをコピーします。
 * \param dst コピー先のメモリ先頭アドレス
 * \param src コピー元のメモリ先頭アドレス
 * \param len コピーする文字列の長さ
 * \return コピー先のメモリ先頭アドレス
 * \ja_end
 */
template <typename T> T*
memCpy(T* dst, const T* src, Size len)
{
  memcpy(dst, src, len * sizeof(T));
  return dst;
}

/*!
 * \ja
 * Tの文字型のメモリブロックを移動します。
 * \param dst 移動先のメモリ先頭アドレス
 * \param src 移動元のメモリ先頭アドレス
 * \param len 移動する文字列の長さ
 * \return コピー先のメモリ先頭アドレス
 * \ja_end
 */
template <typename T> T*
memMove(T* dst, const T* src, Size len)
{
  memmove(dst, src, len * sizeof(T));
  return dst;
}

CCC_NAMESPACE_END(CCC)

#endif /* INCLUDE_ccc_base_cstring_h */
