﻿// $Id$

#include <string.h>
#include <ccc/fetch/ContentType.h>

CCC_NAMESPACE_START(CCC)

void
ContentType::clear()
{
  delete ct;
  delete main_type_str;
  delete sub_type_str;
  delete parameter_str;
  ContentType::ct = 0;
  main_type = MAINTYPE_NOT_SET;
  sub_type = SUBTYPE_NOT_SET;
  main_type_str = 0;
  sub_type_str = 0;
  parameter_str = 0;
  ContentTypeParameterItem* ctpi;
  while ((ctpi = params.pop()))
  {
    delete ctpi;
  }
}

ContentType::ContentType(const char* ct)
{
  ContentType::ct = 0;
  main_type = MAINTYPE_NOT_SET;
  sub_type = SUBTYPE_NOT_SET;
  main_type_str = 0;
  sub_type_str = 0;
  parameter_str = 0;
  if (ct)
  {
    set(ct);
  }
}

ContentType::~ContentType()
{
  clear();
}

bool
ContentType::set(const char* ct)
{
  if (!ct)
  {
    // NULL
    return false;
  }
  static char content_type[] = "Content-Type";
//  static char content_type2[] = "Content-type:";
#ifdef _WIN32_WCE
  if (_strnicmp(ct, content_type, sizeof(content_type) - 1))
#else /* _WIN32_WCE */
#ifdef _WIN32
  if (strnicmp(ct, content_type, sizeof(content_type) - 1))
#else /* _WIN32 */
  if (strncasecmp(ct, content_type, sizeof(content_type) - 1))
#endif /* _WIN32 */
#endif /* _WIN32_WCE */
  {
    // doesn't start from Content-Type:
    return false;
  }
  const char* p = ct + (sizeof(content_type) - 1);
  // skip SP
  while ((*p == ' ') || (*p == '\t'))
  {
    p++;
  }
  // read ':'
  if (*p++ != ':')
  {
    return false;
  }
  size_t len = strlen(ct);
  ContentType::ct = new char[len + 1];
  strcpy(ContentType::ct, ct);
  // skip SP
  while ((*p == ' ') || (*p == '\t'))
  {
    p++;
  }
  const char* x = p;
  while ((*p != '\0') && (*p != '/'))
  {
    p++;
  }
  len = p - x;
  main_type_str = new char[len + 1];
  strncpy(main_type_str, x, len);
  main_type_str[len] = '\0';
  if (*p++ != '/')
  {
    // ERROR: no subtype
    setType();
    return false;
  }
  x = p;
  while ((*p != '\0') && (*p != ';'))
  {
    p++;
  }
  len = p - x;
  sub_type_str = new char[len + 1];
  strncpy(sub_type_str, x, len);
  sub_type_str[len] = '\0';
  setType();
  if (*p != ';')
  {
    // NO parameter
    return true;
  }
  p++;
  // skip SP
  while (*p == ' ')  
  {
    p++;
  }
  x = p;
  while (*p != '\0')
  {
    p++;
  }
  len = p - x;
  parameter_str = new char[len + 1];
  strncpy(parameter_str, x, len);
  parameter_str[len] = '\0';
  // parse parameter
  while (*x)
  {
    p = x;
    while ((*p != '\0') && (*p != '='))
    {
      p++;
    }
    if (*p == '\0')
    {
      // invalid parameter
      break;
    }
    len = p - x;
    char* attribute = new char[len + 1];
    strncpy(attribute, x, len);
    attribute[len] = '\0';
    x = p + 1;
    while ((*p != '\0') && (*p != ';'))
    {
      p++;
    }
    len = p - x;
    char* value = new char[len + 1];
    strncpy(value, x, len);
    value[len] = '\0';
    ContentTypeParameterItem* ctpi = new ContentTypeParameterItem(attribute, value);
    params.inject(ctpi);
    delete[] attribute;
    delete[] value;
    if (*p == ';')
    {
      p++;
    }
    while (*p == ' ')
    {
      p++;
    }
    x = p;
  }
  return true;
}

void
ContentType::setType()
{
  if (main_type_str == 0)
  {
    main_type = MAINTYPE_NOT_SET;
  }
  else
  {
    static const char* main_types[] =
    {
      0,		// MAINTYPE_NOT_SET
      "text", 		// MAINTYPE_TEXT
      "message", 	// MAINTYPE_MESSAGE
      "application",	// MAINTYPE_APPLICATION
      "image",		// MAINTYPE_IMAGE
      "audio",		// MAINTYPE_AUDIO
      "video",		// MAINTYPE_VIDEO
      "multipart",	// MAINTYPE_MULTIPART
      0,		// MAINTYPE_OTHER
    };
    int i;
    for (i = MAINTYPE_NOT_SET + 1; i < MAINTYPE_OTHER; i++)
    {
      if (strcmp(main_type_str, main_types[i]) == 0)
      {
	break;
      }
    }
    main_type = (MainType)i;
  }
  if (sub_type_str == 0)
  {
    sub_type = SUBTYPE_NOT_SET;
  }
  else
  {
    static const char* sub_types[] =
    {
      0,		// SUBTYPE_NOT_SET
      "plain",		// SUBTYPE_PLAIN
      "enriched",	// SUBTYPE_ENRICHED
      "rfc822",		// SUBTYPE_RFC822
      "partial",	// SUBTYPE_PARTIAL
      "extarnal-body",	// SUBTYPE_EXTARNAL_BODY
      "octet-stream",	// SUBTYPE_OCTET_STREAM
      "postscript",	// SUBTYPE_POSTSCRIPT
      "jpeg",		// SUBTYPE_JPEG
      "gif",		// SUBTYPE_GIF
      "basic",		// SUBTYPE_BASIC
      "mpeg",		// SUBTYPE_MPEG
      "mixed",		// SUBTYPE_MIXED
      "alternative",	// SUBTYPE_ALTERNATIVE
      "parallel",	// SUBTYPE_PARALLEL
      "digest",		// SUBTYPE_DIGEST
      "html",		// SUBTYPE_HTML
      "xml",		// SUBTYPE_XML
      "javascript",	// SUBTYPE_JAVASCRIPT
      "css",		// SUBTYPE_CSS
      0,		// SUBTYPE_OTHER
    };
    int i;
    for (i = SUBTYPE_NOT_SET + 1; i < SUBTYPE_OTHER; i++)
    {
      if (strcmp(sub_type_str, sub_types[i]) == 0)
      {
	break;
      }
    }
    sub_type = (SubType)i;
  }
}

CCC_NAMESPACE_END(CCC)

#if 0
// ------------------------------------------------------------------------
// sample code
#include <stdio.h>
#include <ccc/fetch/mime.h>

int
main()
{
  static char* tbl[] =
  {
    "Content-Type:text/plain",
    "Content-Type: text/plain",
    "Content-Type:text/plain; charset=us-ascii",
    "Content-Type: text/plain; charset=us-ascii",
    "Content-Type: text/plain; charset=us-ascii; language=Japanese",
    "Content-Type: text/plain; charset=us-ascii; language=Japanese; country=Japan",
    0,
  };
  for (int i = 0; tbl[i]; i++) 
  {
    printf("----------------------------------------\n");
    printf("[%s]\n", tbl[i]);
    CCC::ContentType ct(tbl[i]);
    printf("MainType: [%s]\n", ct.getMainTypeStr());
    printf("MainType num: %d\n", ct.getMainType());
    printf("SubType: [%s]\n", ct.getSubTypeStr());
    printf("SubType num: %d\n", ct.getSubType());
    printf("Parameter: [%s]\n", ct.getParameter());
    printf("Parameter num:%d\n", ct.getParameterNumber());
    for (int j = 0; j < ct.getParameterNumber(); j++)
    {
      const CCC::ContentTypeParameterItem* ctpi = ct.getNthParameter(j);
      printf("Parameter %d attribute: [%s]\n", j, ctpi->getAttribute());
      printf("Parameter %d value: [%s]\n", j, ctpi->getValue());
    }
  }
}

#endif
