﻿// $Id$

#ifndef INCLUDE_ccc_fetch_ContentTypeParameterItem_h
#define INCLUDE_ccc_fetch_ContentTypeParameterItem_h

#include <ccc/base/base.h>

CCC_NAMESPACE_START(CCC)

/*!
 * Content-Typeのパラメータを表現するクラスです。
 */
class ContentTypeParameterItem
{
  /*!
   * 属性
   */
  char* attribute;
  /*!
   * 値
   */
  char* value;
 public:
  /*!
   * コンストラクタ
   */
  ContentTypeParameterItem(const char* attribute, const char* value);
  /*!
   * デストラクタ
   */
  ~ContentTypeParameterItem();
  /*!
   * 属性文字列を得ます。
   * \return 属性文字列
   */
  const char* getAttribute() const { return attribute; }
  /*!
   * 値文字列を得ます。
   * \return 値文字列
   */
  const char* getValue() const { return value; }
};

CCC_NAMESPACE_END(CCC)

#endif /* INCLUDE_ccc_fetch_ContentTypeParameterItem_h */
