﻿// $Id$
// cyfetch
// Copyright (C) 2003 CYPAC Co., Inc. All rights reserved.

#ifndef INCLUDE_ccc_fetch_HttpFetch_h
#define INCLUDE_ccc_fetch_HttpFetch_h

#include <ccc/base/base.h>
#include <ccc/base/TString.h>
#include <ccc/base/OFlow.h>
#include <ccc/http/HttpHeaderLine.h>
#include <ccc/http/HttpRequestMethod.h>
#include <ccc/http/HttpRequest.h>
#include <ccc/http/HttpResponse.h>

CCC_NAMESPACE_START(CCC)

class Uri;

/*!
 * HTTPプロトコルによる通信を行うクラスです。
 */
class HttpFetch
{
  /*!
   * プロキシアドレス
   */
  const char* proxy;
  /*!
   * プロキシのポート番号
   */
  int proxy_port;
  /*!
   * タイムアウト(秒単位)
   */
  int timeout;

 public:
  enum FetchStatus
  {
    FS_OK,
    FS_URI_ERROR,
    FS_SOCKET_OPEN_ERROR,
    FS_INVALID_RESPONSE_HEADER_ERROR,
    FS_SOCKET_IO_ERROR,
  };
 public:
  /*!
   * コンストラクタ
   */
  HttpFetch();
  /*!
   * デストラクタ
   */
  ~HttpFetch();
  /*!
   * プロキシのアドレスを指定します。
   * 文字列は内部でコピーされます。
   * \param proxy アドレス
   */
  void setProxy(const char* proxy);
  /*!
   * プロキシのポート番号
   * \param port ポート番号
   */
  void setProxyPort(int port);
  /*!
   * タイムアウト(秒単位)を指定します。
   * \param timeout タイムアウト
   */
  void setTimeout(int timeout);
  /*!
   * HTTPプロトコルによる通信を行います。
   * タイムアウトの場合には0が返ります。
   * \param uri URL 
   * \param request 送信データ
   * \param status 処理状況が格納されます。
   * \return 受信データ
   */
  HttpResponse* fetch(Uri* uri, HttpRequest* request, FetchStatus& status);
  /*!
   * HTTPプロトコルによる通信を行います。
   * タイムアウトの場合には0が返ります。
   * \param uri URL 
   * \param request 送信データ
   * \param status 処理状況が格納されます。
   * \param out 受信したbodyデータが書き込まれます。
   * \return 受信データ
   */
  HttpResponse* fetch(Uri* uri, HttpRequest* request, FetchStatus& status, OFlow* out);
};

CCC_NAMESPACE_END(CCC)

#endif /* INCLUDE_ccc_fetch_HttpFetch_h */
