﻿// $Id: httpfetch.cpp 22568 2008-11-13 14:15:36Z mori $

#include <stdlib.h>
#include <string.h>
#include <ccc/fetch/Uri.h>
#include <ccc/fetch/HttpFetch2.h>

CCC_NAMESPACE_START(CCC)

HttpFetch2::HttpFetch2()
{
  proxy = 0;
  proxy_port = 0;
  timeout = 10;
  log = 0;
  sent = 0;
  sent_flow = 0;
  sock = 0;
  in = 0;
  out = 0;
  method = METHOD_GET;
  log_flow = 0; // in
  sent_req = 0; // in
  add_req = 0;  // in
  send_data = 0; // in
  lasterror = NO_ERROR_HTTPFETCH2;
}

HttpFetch2::~HttpFetch2()
{
#ifdef _WIN32_WCE
  delete (void *) proxy;
#else /* _WIN32_WCE */
  delete proxy;
#endif /* _WIN32_WCE */

  delete log;
  delete sock; // use in, out
  delete in;
  delete out;
  delete sent; // use sent_flow
  delete sent_flow;
}

void
HttpFetch2::setProxy(const char* proxy_)
{
#ifdef _WIN32_WCE
  delete (void *) proxy;
#else /* _WIN32_WCE */
  delete proxy;
#endif /* _WIN32_WCE */
  if (proxy_)
  {
    proxy = new char[strlen(proxy_) + 1];
    strcpy((char*)proxy, proxy_);
  }
  else
  {
    proxy = 0;
  }
}

void
HttpFetch2::setProxyPort(int port)
{
  proxy_port = port;
}

void
HttpFetch2::setTimeout(int timeout_)
{
  timeout = timeout_;
}

void 
HttpFetch2::setLogFlow(OFlow* log_flow)
{
  this->log_flow = log_flow;
}

void
HttpFetch2::setSentReq(BString* sent_req)
{
  this->sent_req = sent_req;
}

void
HttpFetch2::setAddReq(const BString* add_req)
{
  this->add_req = add_req;
}

void
HttpFetch2::setSendData(BString* send_data)
{
  this->send_data = send_data;
}
  
void
HttpFetch2::setMethod(Method method)
{
  this->method = method;
}

void
HttpFetch2::setLog()
{
  log = new TextWriter<Int8>(log_flow ? log_flow : &null_oflow);
}

void
HttpFetch2::setSentLog()
{
  if (sent_req)
  {
    sent_flow = new StringOFlow<Int8>((BString*) sent_req);
    sent = new TextWriter<Int8>((OFlow*)&sent_flow);
  }
  else
  {
    sent = new TextWriter<Int8>((OFlow*)&null_oflow2);
  }
}

bool
HttpFetch2::openSocket()
{
  sock = new SocketIOFlow(IOTYPE_INT8);
  sock->setTimeoutSec(timeout);
  if (proxy && proxy_port != 0)
  {
    // use Proxy
    if (!sock->openAfInet(proxy_port, proxy))
    {
      log->setFormat("ERROR: can't open proxy. host:%s port:%d\n");
      log->setTP(proxy);
      log->setSI(proxy_port);
      log->write();
      lasterror = ERROR_PROXY_OPEN;
      return false;
    }
  }
  else
  {
    // direct connection
    if (!sock->openAfInet(uri->getPort(), uri->getHost()))
    {
      log->setFormat("ERROR: can't connect http server. host:%s port:%d\n");
      log->setTP(uri->getHost());
      log->setSI(uri->getPort());
      log->write();
      lasterror = ERROR_CONNECT;
      return false;
    }
  }
  out = new TextWriter<Int8>(sock);
  in  = new TextReader<Int8>(sock);
  return true;
}

bool
HttpFetch2::sendRequest()
{
  static const char* methods[] =
  {
    "GET",	// METHOD_GET
    "POST",	// METHOD_POST
    "HEAD",	// METHOD_HEAD
    "OPTIONS",// METHOD_OPTIONS
    "PUT",	// METHOD_PUT
    "DELETE",	// METHOD_DELETE
    "TRACE",	// METHOD_TRACE
  };
  try
  {
    if (uri->getPort() == 80)
    {
      out->setFormat("%s http://%s%s HTTP/1.0\r\n");
      out->setTP(methods[method]);
      out->setTP(uri->getHost());
      out->setTP(uri->getPath());
      sent->setFormat("%s http://%s%s HTTP/1.0\r\n");
      sent->setTP(methods[method]);
      sent->setTP(uri->getHost());
      sent->setTP(uri->getPath());
    }
    else
    {
      out->setFormat("%s http://%s:%d%s HTTP/1.0\r\n");
      out->setTP(methods[method]);
      out->setTP(uri->getHost());
      out->setSI(uri->getPort());
      out->setTP(uri->getPath());
      sent->setFormat("%s http://%s:%d%s HTTP/1.0\r\n");
      sent->setTP(methods[method]);
      sent->setTP(uri->getHost());
      sent->setSI(uri->getPort());
      sent->setTP(uri->getPath());
    }
    out->write();
    sent->write();
    out->print("Accept: */*\r\n");
    out->print("User-Agent: ccc-httpfetch\r\n");		// TODO: Agent name setting function
    sent->print("Accept: */*\r\n");
    sent->print("User-Agent: ccc-httpfetch\r\n");	// TODO: Agent name setting function
    if (add_req && add_req->getLength() > 0)
    {
      out->print(add_req);
      sent->print(add_req);
    }
    if ((method == METHOD_POST) && (send_data != 0))
    {
      out->setFormat("Content-Length: %u\r\n");
      out->setUI(static_cast<unsigned int>(send_data->getLength()));
      out->write();
      out->print("Content-Type: text/plain\r\n");
      sent->setFormat("Content-Length: %u\r\n");
      sent->setUI(static_cast<unsigned int>(send_data->getLength()));
      sent->write();
      sent->print("Content-Type: text/plain\r\n");
    }
    out->print("\r\n");
    sent->print("\r\n");
    if ((method == METHOD_POST) && (send_data != 0))
    {
      out->print(*send_data);
      sent->print(*send_data);
    }
  }
  catch (IOException ioe)
  {
    lasterror = ERROR_DISCONNECT;
    return false;
  }
  return true;
}

bool
HttpFetch2::receiveResponce(BString* res_hdr)
{
  try
  {
    // receive responce
    BString* line;
    // HTTP/1.1 200 OK
    line = in->readLine();
    if (res_hdr)
    {
      res_hdr->add(*line);
    }
    //log->print(line);
    delete line;
    bool done_p = false;
    data_length = 0;
    BString content_length("Content-Length:");
    while (!done_p)
    {
      line = in->readLine();
      if (res_hdr)
      {
	res_hdr->add(*line);
      }
      //log->print(line);
      if (line->simpleMatch(content_length) == 1)
      {
	// ex.) Content-Length: 2696
	char* p = line->getCString();
	p += content_length.getLength();
	while (*p == ' ')
	{
	  p++;
	}
	data_length = (Size)atoi(p);
      }
      else if (line->strCmp("\r\n") == 0)
      {
	done_p = true;
      }
      delete line;
    }
  }
  catch (IOException ioe)
  {
    lasterror = ERROR_DISCONNECT;
    return false;
  }
  return true;
}

bool
HttpFetch2::receiveData()
{
  const Size BUFF_SIZE = 64*1024;
  Int8* buff = new Int8[BUFF_SIZE];
  if (data_length > 0)
  {
    Size left_size = data_length;
    while (left_size > 0)
    {
      Size get_size = (left_size > BUFF_SIZE) ? BUFF_SIZE : left_size;
      in->getBlock(get_size, buff, get_size);
      if (!write(buff, get_size))
      {
        delete[] buff;
	lasterror = ERROR_FILE_WRITE;
	return false;
      }
      left_size -= get_size;
    }
  }
  else
  {
    // no Content-Length: response
    Size get_size = 0;
    try
    {
      for(;;)
      {
	Int8 * p = buff;
	get_size = 0;
	do {
	  *p++ = in->getChar();
	  get_size++;
	} while (get_size < BUFF_SIZE);
	if (!write(buff, get_size))
	{
          delete[] buff;
	  lasterror = ERROR_FILE_WRITE;
	  return false;
	}
      }
    }
    catch (IOException ioe)
    {
      if (ioe.errorNum() == IOException::READ_BEYOND_THE_EOF)
      {
	if (!write(buff, get_size))
	{
          delete[] buff;
	  lasterror = ERROR_FILE_WRITE;
	  return false;
	}
      }
      else
      {
        delete[] buff;
	throw ioe;
      }
    }
  }
  delete[] buff;
  return true;
}

void
HttpFetch2::setUri(Uri* uri)
{
  this->uri = uri;
}

bool
HttpFetch2::fetch(BString* res_hdr) CCC_RAISES(IOException)
{
  
  setLog();  
  setSentLog();

  // check this URI
  if (uri->getScheme() != Uri::SCHEME_HTTP)
  {
    log->print("ERROR: URI isn't for the HTTP.\n");
    lasterror = ERROR_HTTP_SCHEME;
    return false;
  }
  try
  {
    if (!openSocket())
      return false;
    if (!sendRequest())
      return false;
    if (!receiveResponce(res_hdr))
      return false;
    if (!receiveData())
      return false;
  }
  catch (IOException ioe)
  {
    log->setFormat("ERROR: I/O error. %s\n");
    log->setTP(ioe.getErrorString());
    log->write();	
    return false;
  }
  return true;
}

CCC_NAMESPACE_END(CCC)
