﻿// $Id: httpfetch.h 22392 2008-10-08 06:22:24Z mori $
// cyfetch
// Copyright (C) 2003 CYPAC Co., Inc. All rights reserved.

#ifndef INCLUDE_ccc_fetch_HttpFetch2_h
#define INCLUDE_ccc_fetch_HttpFetch2_h

#include <ccc/base/base.h>
#include <ccc/base/TString.h>
#include <ccc/base/OFlow.h>
#include <ccc/base/NullOFlow.h>
#include <ccc/base/StringOFlow.h>
#include <ccc/base/TextWriter.h>
#include <ccc/base/TextReader.h>
#include <ccc/posix/SocketIOFlow.h>

CCC_NAMESPACE_START(CCC)

class Uri;

/*!
 * HTTPプロトコルによる通信を行うクラスです。
 */
class HttpFetch2
{
  /*!
   * プロキシアドレス
   */
  const char* proxy;
  /*!
   * プロキシのポート番号
   */
  int proxy_port;
  /*!
   * タイムアウト(秒単位)
   */
  int timeout;

  NullOFlow null_oflow;
  NullOFlow null_oflow2;
  TextWriter<Int8> * log;
  TextWriter<Int8> * sent;
  StringOFlow<Int8>* sent_flow;
  SocketIOFlow* sock;
  TextReader<Int8> * in;
  TextWriter<Int8> * out;
  Size data_length;

  OFlow* log_flow; /* in */
  const BString* sent_req; /* in */
  const BString* add_req; /* in */
  Uri* uri; /* in */
  const BString* send_data; /* in */
  
  void setLog();
  void setSentLog();
  bool openSocket();
  bool sendRequest();
  bool receiveResponce(BString* res_hdr);
  bool receiveData();
 public:
  enum Error
  {
    NO_ERROR_HTTPFETCH2 = 0,	// !< no error
    ERROR_PROXY_OPEN,		// !< can't open proxy
    ERROR_CONNECT,		// !< can't connect http server
    ERROR_FILE_WRITE,		// !< file write error
    ERROR_HTTP_SCHEME,  	// !< SCHEME not HTTP
    ERROR_DISCONNECT,   	// !< disconnect http
  };
  
  
  /*!
   * HTTPのメソッドを示します。
   */
  enum Method
  {
    METHOD_GET,
    METHOD_POST,
    METHOD_HEAD,
    METHOD_OPTIONS,
    METHOD_PUT,
    METHOD_DELETE,
    METHOD_TRACE,
  };

 private:
  Method method;
  Error  lasterror;
 public:
  /*!
   * コンストラクタ
   */
  HttpFetch2();
  /*!
   * デストラクタ
   */
  ~HttpFetch2();
  /*!
   * プロキシのアドレスを指定します。
   * 文字列は内部でコピーされます。
   * \param proxy アドレス
   */
  void setProxy(const char* proxy);
  /*!
   * プロキシのポート番号
   * \param port ポート番号
   */
  void setProxyPort(int port);
  /*!
   * タイムアウト(秒単位)を指定します。
   * \param timeout タイムアウト
   */
  void setTimeout(int timeout);
  /*!
   * 利用者が変更するデータ書き込みメソッド
   * \param memptr
   * \param wirte_size
   */
  virtual bool write(void* memptr, CCC::Size write_size) = 0;
  /*!
   * ログの出力フローを設定します。
   * \param log ログの出力先フローを指定します。
   */
  void setLogFlow(OFlow* log_flow);
  /*!
   *
   * \param sent_req 送信したリクエストの内容をセットする文字列を指定します。(0を指定すると、リクエストは記録されません。)
   */
  void setSentReq(BString* sent_req);
  /*!
   *
   * \param add_req リクエストへッダの追加内容を指定します。
   */
  void setAddReq(const BString* add_req);
  /*!
   * \param method メソッドを指定します。
   */
  void setMethod(Method method);
  /*!
   * \param send_data 送信データを指定します
   */
  void setSendData(BString* send_data);
  /*!
   * URIを設定します
   * \param uri
   */
  void setUri(Uri* uri);
  /*!
   * HTTPプロトコルによる通信を行います。
   * \param res_hdr 受信したレスポンスへッダをセットする文字列を指定します。0を指定すると、レスポンスは記録されません。
   * \retval false エラーが発生したためデータの取得が行えませんでした。
   * \retval true 正常にデータの取得が行えました。
   */
    bool fetch(BString* res_hdr) CCC_RAISES(IOException);
    Error getLastError() { return lasterror; }
};

CCC_NAMESPACE_END(CCC)

#endif /* INCLUDE_ccc_fetch_HttpFetch2_h */
