﻿// $Id$

#ifndef INCLUDE_ccc_file_FileIFlow_h
#define INCLUDE_ccc_file_FileIFlow_h

#include <stdio.h>
#include <ccc/base/IFlow.h>

CCC_NAMESPACE_START(CCC)

class PathString;

/*!
 * \ja
 * FILEインターフェースを使用したファイル入力用のクラスです。
 * \ja_end
 */
class FileIFlow
  : public IFlow
{
 protected:
  /*!
   * \ja
   * ファイルポインタ
   * \ja_end
   */
  FILE* fp;
  /*!
   * \ja
   * アタッチされた場合にtrueとなり、クローズの処理が行なわれません。
   * \ja_end
   */
  bool attached_p;

 public:
  /*!
   * \ja
   * コンストラクタ
   * \ja_end
   */
  FileIFlow();
  /*!
   * \ja
   * デストラクタ
   * \ja_end
   */
  virtual ~FileIFlow();
  /*!
   * \ja
   * ファイルをオープンします。
   * \param path パス
   * \param binary_p バイナリオプションでファイルを開く時にtrueを指定します。
   *		     デフォルトはtrueです。
   * \retval true  成功
   * \retval false 失敗
   * \ja_end
   */
  bool open(const PathString* path, bool binary_p = true);
  /*!
   * \ja
   * ファイルをオープンします。
   * \param path パス
   * \param binary_p バイナリオプションでファイルを開く時にtrueを指定します。
   *		     デフォルトはtrueです。
   * \retval true  成功
   * \retval false 失敗
   * \ja_end
   */
  bool open(const char* path, bool binary_p = true);
#ifdef _WIN32
  /*!
   * \ja
   * ファイルをオープンします。
   * \param path パス
   * \param binary_p バイナリオプションでファイルを開く時にtrueを指定します。
   *		     デフォルトはtrueです。
   * \retval true  成功
   * \retval false 失敗
   * \ja_end
   */
  bool open(const wchar_t* path, bool binary_p = true);
#endif /* _WIN32 */
  /*!
   * \ja
   * ファイルポインタをアタッチします。
   * \param fp アタッチするファイルポインタ
   * \ja_end
   */
  void attach(FILE* fp);
  /*!
   * \ja
   * ファイルポインタを取得します。
   * \ja_end
   */
  FILE* getFp() { return fp; }
  /*!
   * \ja
   * アタッチされたファイルポインタかどうかを調べます。
   * \retval true アタッチされたファイルポインタ
   * \retval false アタッチされたファイルポインタではない
   * \ja_end
   */
  bool attachedP() { return attached_p; }
  /*!
   * \ja
   * ファイルをクローズします。
   * アタッチされたファイルポインタの場合にはクローズされません。
   * \retval true 成功
   * \retval false 失敗
   * \ja_end
   */
  bool close();
  /*!
   * \ja
   * IFlowのドキュメントを参照して下さい。
   * \ja_end
   */
  virtual Int8 getInt8() CCC_RAISES(IOException);
  /*!
   * \ja
   * IFlowのドキュメントを参照して下さい。
   * \ja_end
   */
  virtual UInt16 getUInt16() CCC_RAISES(IOException);
  /*!
   * \ja
   * IFlowのドキュメントを参照して下さい。
   * \ja_end
   */
  virtual UInt32 getUInt32() CCC_RAISES(IOException);
  /*!
   * \ja
   * IFlowのドキュメントを参照して下さい。
   * \ja_end
   */
  virtual void getInt8Block(Size block_size, Int8* ptr, Size& get_size) CCC_RAISES(IOException);
  /*!
   * \ja
   * IFlowのドキュメントを参照して下さい。
   * \ja_end
   */
  virtual void getUInt16Block(Size block_size, UInt16* ptr, Size& get_size) CCC_RAISES(IOException);
  /*!
   * \ja
   * IFlowのドキュメントを参照して下さい。
   * \ja_end
   */
  virtual void getUInt32Block(Size block_size, UInt32* ptr, Size& get_size) CCC_RAISES(IOException);
  /*!
   * \ja
   * Flowのドキュメントを参照して下さい。
   * \ja_end
   */
  virtual bool rewind();
  /*!
   * \ja
   * Flowのドキュメントを参照して下さい。
   * \ja_end
   */
  virtual bool openedP();
};

/*!
 * \ja
 * 標準入力を対象とする入力フロー
 * \ja_end
 */
extern FileIFlow* stdin_flow;

CCC_NAMESPACE_END(CCC)

#endif /* INCLUDE_ccc_file_FileIFlow_h */
