﻿// $Id$

#ifndef INCLUDE_ccc_file_FileOFlow_h
#define INCLUDE_ccc_file_FileOFlow_h

#include <stdio.h>
#include <ccc/base/OFlow.h>

CCC_NAMESPACE_START(CCC)

class PathString;

/*!
 * \ja
 * FILEインターフェースを使用したファイル出力用のクラスです。
 * \ja_end
 */
class FileOFlow
  : public OFlow
{
 protected:
  FILE* fp;
  bool attached_p;

 public:
  /*!
   * \ja
   * コンストラクタ
   * \ja_end
   */
  FileOFlow();
  /*!
   * \ja
   * デストラクタ
   * \ja_end
   */
  virtual ~FileOFlow();
  /*!
   * \ja
   * ファイルをオープンします。
   * \param path パス
   * \param append_p 追記する場合にはtrueを指定します。
   *		     デフォルトはfalseです。
   * \param binary_p バイナリオプションでファイルを開く時にtrueを指定します。
   *		     デフォルトはtrueです。
   * \retval true  成功
   * \retval false 失敗
   * \ja_end
   */
  bool open(const PathString* path, bool append_p = false, bool binary_p = true);
  /*!
   * \ja
   * ファイルをオープンします。
   * \param path パス
   * \param append_p 追記する場合にはtrueを指定します。
   *		     デフォルトはfalseです。
   * \param binary_p バイナリオプションでファイルを開く時にtrueを指定します。
   *		     デフォルトはtrueです。
   * \retval true  成功
   * \retval false 失敗
   * \ja_end
   */
  bool open(const char* path, bool append_p = false, bool binary_p = true);
#ifdef _WIN32
  /*!
   * \ja
   * ファイルをオープンします。
   * \param path パス
   * \param append_p 追記する場合にはtrueを指定します。
   *		     デフォルトはfalseです。
   * \param binary_p バイナリオプションでファイルを開く時にtrueを指定します。
   *		     デフォルトはtrueです。
   * \retval true  成功
   * \retval false 失敗
   * \ja_end
   */
  bool open(const wchar_t* path, bool append_p = false, bool binary_p = true);
#endif /* _WIN32 */
  /*!
   * \ja
   * ファイルポインタをアタッチします。
   * \param fp アタッチするファイルポインタ
   * \ja_end
   */
  void attach(FILE* fp);
  /*!
   * \ja
   * アタッチされたファイルポインタかどうかを調べます。
   * \retval true アタッチされたファイルポインタ
   * \retval false アタッチされたファイルポインタではない
   * \ja_end
   */
  bool attachedP() { return attached_p; }
  /*!
   * \ja
   * ファイルをクローズします。
   * アタッチされたファイルポインタの場合にはクローズされません。
   * \retval true 成功
   * \retval false 失敗
   * \ja_end
   */
  virtual bool close();
  /*
   * \ja
   * バッファリング中の出力を書出します。
   * \ja_end
   */
  virtual void flush() CCC_RAISES(IOException);
  /*!
   * \ja
   * OFlowのドキュメントを参照して下さい。
   * \ja_end
   */
  virtual void putInt8(Int8 c) CCC_RAISES(IOException);
  /*!
   * \ja
   * OFlowのドキュメントを参照して下さい。
   * \ja_end
   */
  virtual void putUInt16(UInt16 c) CCC_RAISES(IOException);
  /*!
   * \ja
   * OFlowのドキュメントを参照して下さい。
   * \ja_end
   */
  virtual void putUInt32(UInt32 c) CCC_RAISES(IOException);
  /*!
   * \ja
   * OFlowのドキュメントを参照して下さい。
   * \ja_end
   */
  virtual void putInt8Block(Size block_size, const Int8* ptr, Size& put_size) CCC_RAISES(IOException);
  /*!
   * \ja
   * OFlowのドキュメントを参照して下さい。
   * \ja_end
   */
  virtual void putUInt16Block(Size block_size, const UInt16* ptr, Size& put_size) CCC_RAISES(IOException);
  /*!
   * \ja
   * OFlowのドキュメントを参照して下さい。
   * \ja_end
   */
  virtual void putUInt32Block(Size block_size, const UInt32* ptr, Size& put_size) CCC_RAISES(IOException);
  /*!
   * \ja
   * Flowのドキュメントを参照して下さい。
   * \ja_end
   */
  virtual bool rewind();
  /*!
   * \ja
   * Flowのドキュメントを参照して下さい。
   * \ja_end
   */
  virtual bool openedP();
};

/*!
 * \ja
 * 標準出力を対象とする出力フロー
 * \ja_end
 */
extern FileOFlow* stdout_flow;
/*!
 * \ja
 * 標準エラー出力を対象とする出力フロー
 * \ja_end
 */
extern FileOFlow* stderr_flow;

CCC_NAMESPACE_END(CCC)

#endif /* INCLUDE_ccc_file_FileOFlow_h */
