﻿// $Id$

#include <ccc/file/InitializeStdFileFlow.h>
#include <ccc/file/FileIFlow.h>
#include <ccc/file/FileOFlow.h>
#include <ccc/base/TextReader.h>
#include <ccc/base/TextWriter.h>
#include <ccc/base/NullOFlow.h>

CCC_NAMESPACE_START(CCC)

FileIFlow* stdin_flow = 0;
FileOFlow* stdout_flow = 0;
FileOFlow* stderr_flow = 0;

void
InitializeStdFileFlow::initializeStdFileFlow()
{
  //printf("InitializeStdFileFlow()\n");
  stdin_flow = new FileIFlow();
  stdin_flow->attach(stdin);
  stdout_flow = new FileOFlow();
  stdout_flow->attach(stdout);
  stderr_flow = new FileOFlow();
  stderr_flow->attach(stderr);

  stdin_r8 = new TextReader<Int8>(stdin_flow);
  stdin_r16 = new TextReader<UInt16>(stdin_flow);
  stdin_r32 = new TextReader<UInt32>(stdin_flow);
  stdout_w8 = new TextWriter<Int8>(stdout_flow);
  stdout_w16 = new TextWriter<UInt16>(stdout_flow);
  stdout_w32 = new TextWriter<UInt32>(stdout_flow);
  stderr_w8 = new TextWriter<Int8>(stderr_flow);
  stderr_w16 = new TextWriter<UInt16>(stderr_flow);
  stderr_w32 = new TextWriter<UInt32>(stderr_flow);
}

void
InitializeStdFileFlow::unInitializeStdFileFlow()
{
  //printf("~InitializeStdFileFlow()\n");
  delete stdin_r8;
  delete stdin_r16;
  delete stdin_r32;
  delete stdout_w8;
  delete stdout_w16;
  delete stdout_w32;
  delete stderr_w8;
  delete stderr_w16;
  delete stderr_w32;

  delete stdin_flow;
  delete stdout_flow;
  delete stderr_flow;
}

// for ccc/file initialization

static bool
initializeFile(bool init_p)
{
  if (init_p)
  {
    InitializeStdFileFlow::initializeStdFileFlow();
  }
  else
  {
    InitializeStdFileFlow::unInitializeStdFileFlow();
  }
  return true;
}

static int initialize_file_dummy = Ccc::setInitializeHandler(CM_FILE, &initializeFile);

#if 0
int
get_initialize_file_dummy()
{
  return initialize_file_dummy;
}
#endif

CCC_NAMESPACE_END(CCC)
