﻿// $Id$

#ifndef INCLUDE_ccc_file_PathString_h
#define INCLUDE_ccc_file_PathString_h

#ifdef _WIN32
#  include <wchar.h>
#endif /* _WIN32 */
#include <ccc/base/base.h>
#include <ccc/iceman/Iceman.h>
#include <ccc/iceman/Utf8String.h>
#include <ccc/iceman/Utf16String.h>
#include <ccc/xml/DOMString.h>

CCC_NAMESPACE_START(CCC)

#ifdef _WIN32
#  define CCC_UTF16_PATHSTRING
#endif /* _WIN32 */

#ifdef CCC_UTF16_PATHSTRING
typedef CCC::UInt16 PathChar;
#define CCC_PATH_ENCODING CCC::CEID_UTF16N
#define CCC_PATH_STRING_BASE Utf16String
typedef DSubString PathSubString;
#endif /* CCC_UTF16_PATHSTRING */

#ifdef CCC_CP932_PATHSTRING
typedef char PathChar;
#define CCC_PATH_ENCODING CCC::CEID_CP932
#define CCC_PATH_STRING_BASE BString
typedef BSubString PathSubString;
#endif /* CCC_CP932_PATHSTRING */

#ifndef CCC_PATH_STRING_BASE
#  define CCC_UTF8_PATHSTRING
#endif /* CCC_PATH_STRING_BASE */

#ifdef CCC_UTF8_PATHSTRING
typedef char PathChar;
#define CCC_PATH_ENCODING CCC::CEID_UTF8N
#define CCC_PATH_STRING_BASE Utf8String
typedef BSubString PathSubString;
#endif /* CCC_UTF8_PATHSTRING */

/*!
 * directory separator
 */
#ifdef _WIN32
const PathChar directory_separator = '\\';
#else /* _WIN32 */
const PathChar directory_separator = '/';
#endif /* _WIN32 */

/*!
 * The file path string class.
 */
class PathString
  : public CCC_PATH_STRING_BASE
{
 public:
  /*!
   * constructor
   */
  PathString();
  /*!
   * constructor
   * \param path path
   */
  PathString(const PathString& path);
  /*!
   * constructor
   * \param path path
   */
  PathString(const PathString* path);
  /*!
   * constructor
   * \param path path
   */
  PathString(const PathChar* path);
  /*!
   * constructor
   * \param path path
   * \param size size
   */
  PathString(const PathChar* path, Size size);
#ifdef CCC_UTF16_PATHSTRING
  /*!
   * constructor
   * \param utf8_path path
   */
  PathString(const char* utf8_path);
  /*!
   * constructor
   * \param utf8_path path
   */
  PathString(const char* utf8_path, Size size);
  /*!
   * constructor
   * \param enc encoding
   * \param path path
   */
  PathString(CeId enc, const char* path);
  /*!
   * constructor
   * \param enc encoding
   * \param path path
   * \param size size
   */
  PathString(CeId enc, const char* path, Size size);
  /*!
   * constructor
   * \param path path
   */
  PathString(const DOMString* path);
#else /* CCC_UTF16_PATHSTRING */
#ifndef CCC_SINGLE_BYTE_DOM_STRING
  /*!
   * constructor
   * \param path path
   */
  PathString(const DOMString* path);
#endif /* CCC_SINGLE_BYTE_DOM_STRING */
#endif /* CCC_UTF16_PATHSTRING */
  /*!
   * destructor
   */
  ~PathString();
  /*!
   * assign
   */
  void assign(const PathString& path);
  /*!
   * assign
   */
  void assign(const PathString* path);
  /*!
   * assign
   */
  void assign(const PathChar* path);
  /*!
   * assign
   */
  void assign(const PathChar* path, Size size);
#ifdef CCC_UTF16_PATHSTRING
  /*!
   * assign
   * \param utf8_path UTF8 path
   */
  void assign(const char* utf8_path);
  /*!
   * assign
   * \param utf8_path UTF8 path
   * \param size size
   */
  void assign(const char* utf8_path, Size size);
  /*!
   * assign
   * \param enc encoding
   * \param path path
   */
  void assign(CeId enc, const char* path);
  /*!
   * assign
   * \param enc encoding
   * \param path path
   * \param size
   */
  void assign(CeId enc, const char* path, Size size);
#else /* CCC_UTF16_PATHSTRING */
#ifndef CCC_SINGLE_BYTE_DOM_STRING
  /*!
   * assign
   * \param path path
   */
  void assign(const DOMString* path);
#endif /* CCC_SINGLE_BYTE_DOM_STRING */
#endif /* CCC_UTF16_PATHSTRING */
  /*!
   * add string
   * \param path path
   */
  void add(const PathString& path);
  /*!
   * add string
   * \param path path
   */
  void add(const PathString* path);
  /*!
   * add string
   * \param path path
   */
  void add(const PathChar* path);
  /*!
   * add string
   * \param path path
   * \param size size
   */
  void add(const PathChar* path, Size size);
  /*!
   * add string
   * \param c character to be added
   */
  void add(PathChar c);
#ifdef CCC_UTF16_PATHSTRING
  /*!
   * add string
   * \param utf8_path UTF8 path
   */
  void add(const char* utf8_path);
  /*!
   * add string
   * \param utf8_path UTF8 path
   * \param size size
   */
  void add(const char* utf8_path, Size size);
  /*!
   * add string
   * \param enc encoding
   * \param path path
   */
  void add(CeId enc, const char* path);
  /*!
   * add string
   * \param enc encoding
   * \param path path
   * \param size
   */
  void add(CeId enc, const char* path, Size size);
  /*!
   * add character
   * \param c character to be added
   */
  void add(char c);
#else /* CCC_UTF16_PATHSTRING */
#ifndef CCC_SINGLE_BYTE_DOM_STRING
  /*!
   * assign
   * \param path path
   */
  void add(const DOMString* path);
#endif /* CCC_SINGLE_BYTE_DOM_STRING */
#endif /* CCC_UTF16_PATHSTRING */
  /*!
   * normalize path string to handle path later than iOS 10.3 APFS.
   */
  void normalize();
  /*!
   * remove last directory separator
   */
  void removeLastDirectorySeparator();
  /*!
   * add path
   */
  void addDirectorySeparator();
  /*!
   * append sub path component
   * \param sub_path appending sub path
   */
  void appendPathComponent(const PathString* sub_path);
  void appendPathComponent(const PathChar* sub_path);
  void appendPathComponent(const PathChar* sub_path, Size len);
#ifdef CCC_UTF16_PATHSTRING
  /*!
   * append sub path component
   * \param sub_path appending UTF-8 sub path
   */
  void appendPathComponent(const char* utf8_sub_path);
#endif /* CCC_UTF16_PATHSTRING */
  /*!
   * assign with appending sub path component
   * \param ref assigned path
   * \param sub_path appending sub path
   */
  void assignWithAppendingPathComponent(const PathString* ref, const PathString* sub_path);
  void assignWithAppendingPathComponent(const PathString* ref, const PathChar* sub_path);
  void assignWithAppendingPathComponent(const PathString* ref, const PathChar* sub_path, Size len);
#ifdef CCC_UTF16_PATHSTRING
  /*!
   * assign with appending sub path component
   * \param ref assigned path
   * \param sub_path appending UTF-8 sub path
   */
  void assignWithAppendingPathComponent(const PathString* ref, const char* utf8_sub_path);
#endif /* CCC_UTF16_PATHSTRING */
  /*!
   * This method deletes last path component including last path separator.
   */
  void deleteLastPathComponent();
  /*!
   * This method deletes last path component including last path separator.
   * \retval true removed, path separator was found.
   * \retval false not removed
   */
  bool deleteLastPathComponentX();
  /*!
   * get last path component
   * \param result result will be set.
   */
  void getLastPathComponent(PathString* result) const;
  /*!
   * get the base name.
   * \param basename base name string will be set.
   */
  void getBaseName(PathString* basename) const;
  /*!
   * get path extension
   * \param ext path extension string will be set, which will not include
   * preceding period.  If path path string does not include extension,
   * empty string will be set.
   */
  void getFileExtention(PathString* ext) const;
  // void changeFileExtention(PathString* new_ext);
  // void removeFileExtention(PathString* ext);
  // void getDirectory(PathString* dir);
  /*!
   * This method counts the number of derectory separators in this path.
   * \return depth
   */
  unsigned int getPathDepth();
#ifdef _WIN32
  /*!
   * \ja
   * コンストラクタ<br>
   * 引数で渡した文字列の内容で生成する文字列の内容が初期化されます。
   * \param wstr ヌルで終端された文字列へのポインタ
   * \ja_end
   */
  PathString(const wchar_t* wstr);
  /*!
   * \ja
   * 文字列を代入します。
   * \param str 代入する文字列
   * \ja_end
   */
  void assign(const wchar_t* wstr);
  /*!
   * \ja
   * 文字列にヌルで終端された文字列を追加します。
   * \param c_str ヌルで終端された文字列
   * \ja_end
   */
  void add(const wchar_t* wstr);
#endif /* _WIN32 */
};

CCC_NAMESPACE_END(CCC)

#endif /* INCLUDE_ccc_file_PathString_h */
