﻿// $Id$

#include <stdio.h>
#include <string.h>
#include <ccc/http/Cookie.h>
#include <ccc/base/StringOFlow.h>
#include <ccc/base/StringIFlow.h>
#include <ccc/base/TextReader.h>

CCC_NAMESPACE_START(CCC)

Cookie::Cookie(const BString* set_cookie_str)
{
  //printf("Cookie::Cookie(\"%s\")\n", set_cookie_str->getCString());
  clear();
  if (!analyze(set_cookie_str))
  {
    clear();
  }
}

Cookie::~Cookie()
{
}

void
Cookie::clear()
{
  name.clear();
  value.clear();
  httponly_p = false;
  secure_p = false;
  path.clear();
  domain.clear();
  expire = 0;
}

bool
Cookie::analyze(const BString* set_cookie_str)
{
  const char* x = set_cookie_str->getCString();
  bool eof_p = false;
  // cookie-pair
  {
    const char* k = strstr(x, "=");
    if (k == 0)
    {
      return false;
    }
    name.assign(x, k - x);
    k++;
    const char* v = strstr(k, "; ");
    if (v == 0)
    {
      value.assign(k);
      x = 0;
    }
    else
    {
      value.assign(k, v - k);
      x = v + 2;
    }
  }
  // cookie-av ...
  while (x != 0)
  {
    BString av;
    const char* next = strstr(x, "; ");
    if (next == 0)
    {
      av.assign(x);
      x = 0;
    }
    else
    {
      av.assign(x, next - x);
      x = next + 2;
    }
    // cookie-av = expires-av / max-age-av / domain-av / path-av / secure-av / httponly-av / extension-av
    if (av.strNCaseCmp("Secure") == 0)			// secure-av
    {
      secure_p = true;
    }
    else if (av.strNCaseCmp("HttpOnly") == 0)		// httponly-av
    {
      httponly_p = true;
    }
    else
    {
      const char* av_start = av.getCString();
      const char* v = strstr(av_start, "=");
      if (v != 0)
      {
	BString v1(av_start, v - av_start);
	BString v2(v + 1);
	if (v1.strNCaseCmp("Expires") == 0)		// expires-av
	{
	  /* 未実装 */
	}
	else if (v1.strNCaseCmp("Max-Age") == 0)	// max-age-av
	{
	  time_t t = time(0);
	  unsigned int x = v2.getUInt();
	  expire = t + (time_t)x;
	}
	else if (v1.strNCaseCmp("Domain") == 0)		// domain-av
	{
	  domain.assign(v2);
	}
	else if (v1.strNCaseCmp("Path") == 0)		// path-av
	{
	  path.assign(v2);
	}
	else						// extension-av
	{
	  // do nothing
	}
      }
    }
  }
  return true;
}

void
Cookie::dump(TextWriter<Int8>* out)
{
  out->printf("# Cookie\n");
  out->printf("name:%s\n", name.getCString());
  out->printf("value:%s\n", value.getCString());
  out->printf("httponly_p:%s\n", httponly_p ? "true" : "false");
  out->printf("secure_p:%s\n", secure_p ? "true" : "false");
  out->printf("path:%s\n", path.getCString());
  out->printf("domain:%s\n", domain.getCString());
  out->printf("expire:%u\n", (unsigned int)expire);
  out->flush();
}

CCC_NAMESPACE_END(CCC)

