﻿// $Id$

#ifndef INCLUDE_ccc_http_Cookie_h
#define INCLUDE_ccc_http_Cookie_h

#include <time.h>
#include <ccc/base/base.h>
#include <ccc/base/TString.h>
#include <ccc/base/TextWriter.h>

CCC_NAMESPACE_START(CCC)

/*!
 * UA側のクッキーデータを示します。
 * RFC6265
 */
class Cookie
{
  /*!
   * クッキー名称
   */
  BString name;
  /*!
   * クッキー値
   */
  BString value;
  /*!
   * "HttpOnly"属性を示します。
   * 未指定の場合はfalse
   */
  bool httponly_p;
  /*!
   * "Secure"属性を示します。
   * 未指定の場合はfalse
   */
  bool secure_p;
  /*!
   * パス
   */
  BString path;
  /*!
   * ドメイン
   */
  BString domain;
  /*!
   * クッキーの賞味期限
   * 未指定の場合は0
   * 当面: Max-Ageのみの実装, Expiresは未実装です。
   */
  time_t expire;
 public:
  /*!
   * コンストラクタ
   * \param set_cookie_str Set-Cookie:ヘッダのSet-Cookie:に続く指定値
   */
  Cookie(const BString* set_cookie_str);
  /*!
   * デストラクタ
   */
  ~Cookie();
  /*!
   * クッキー名称
   */
  const BString* getName() { return &name; }
  /*!
   * クッキー値
   */
  const BString* getValue() { return &value; }
  /*!
   * "HttpOnly"属性を示します。
   */
  bool httpOnlyP() { return httponly_p; }
  /*!
   * "Secure"属性を示します。
   */
  bool secureP() { return secure_p; }
  /*!
   * パス
   */
  BString* getPath() { return &path; }
  /*!
   * ドメイン
   */
  BString* getDomain() { return &domain; }
  /*!
   * クッキーの賞味期限
   */
  time_t getExpire() { return expire; }
  /*!
   * ダンプ
   * \param out 出力先
   */
  void dump(TextWriter<Int8>* out);
 private:
  /*!
   * Set-Cookie:の指定値を解析します。
   * \param set_cookie_str Set-Cookie:ヘッダのSet-Cookie:に続く指定値
   * \retval true 正常に解析できました。
   * \retval false 文法エラーです。
   */
  bool analyze(const BString* set_cookie_str);
  /*!
   * 初期状態にセットします。
   */
  void clear();
};

CCC_NAMESPACE_END(CCC)

#endif /* INCLUDE_ccc_http_Cookie_h */
