﻿// $Id$

#include <string.h>
#include <ccc/http/CookieBag.h>
#include <ccc/http/Cookie.h>
#include <ccc/fetch/Uri.h>
#include <ccc/http/HttpResponse.h>
#include <ccc/http/HttpRequest.h>
#include <ccc/base/TextWriter.h>

CCC_NAMESPACE_START(CCC)

CookieBag::CookieBag()
{
}

CookieBag::~CookieBag()
{
  clear();
}

void
CookieBag::clear()
{
  Cookie* cookie;
  while ((cookie = cookies.pop()) != 0)
  {
    delete cookie;
  }
}

bool
CookieBag::clearExpired()
{
  return false;	// TODO:
}

bool
CookieBag::getCookie(const Uri* uri, const HttpResponse* http_res)
{
  bool ret = false;
  Iterator<HttpHeaderLine>* itr = http_res->makeHeaderLineIterator();
  HttpHeaderLine* line;
  while ((line = itr->next()) != 0)
  {
    if (line->getFieldType() == HttpHeaderLine::FT_SET_COOKIE)
    {
      Cookie* cookie = new Cookie(line->getValue2());
      if (cookie->getDomain()->getLength() == 0)
      {
	cookie->getDomain()->assign(uri->getHost());
      }
      if (cookie->getPath()->getLength() == 0)
      {
	const char* file_path = uri->getPath();
	const char* x = strrchr(file_path, '/');
	if (x != 0)
	{
	  BString path(file_path, x - file_path + 1);	/* includes '/' */
	  cookie->getPath()->assign(path);
	}
      }
      //cookie->dump(stdout_w8);
      /* 同じクッキーがあったら古い方のエントリを削除 */
      {
	Iterator<Cookie>* itr2 = cookies.createIterator();
	Cookie* c;
	while ((c = itr2->next()) != 0)
	{
	  if ((cookie->getName()->strCmp(c->getName()) == 0) &&
	      (cookie->getDomain()->strNCaseCmp(*c->getDomain()) == 0) &&
	      (cookie->getPath()->strCmp(c->getPath()) == 0))
	  {
	    cookies.remove(c);
	    delete c;
	    break;
	  }
	}
	delete itr2;
      }
      cookies.add(cookie);
      ret = true;
    }
  }
  delete itr;
  return ret;
}

bool
CookieBag::setCookie(const Uri* uri, HttpRequest* http_req)
{
  const char* path = uri->getPath();
  BString header("Cookie: ");
  Iterator<Cookie>* itr = cookies.createIterator();
  Cookie* cookie;
  unsigned int number_of_matched = 0;
  while ((cookie = itr->next()) != 0)
  {
    /* uriのドメインとパスが合致するかを調べます。*/
    if (cookie->getDomain()->strNCaseCmp(uri->getHost()) == 0)
    {
      BString* cookie_path = cookie->getPath();
      if (strncmp(path, cookie_path->getCString(), cookie_path->getLength()) == 0)
      {
	if (number_of_matched++ > 0)
	{
	  header.add("; ");
	}
	header.add(*cookie->getName());
	header.add("=");
	header.add(*cookie->getValue());
      }
    }
  }

  if (number_of_matched > 0)
  {
    header.add("\r\n");
    http_req->addHeader(&header);
    return true;
  }
  return false;
}

CCC_NAMESPACE_END(CCC)
