﻿// $Id$

#ifndef INCLUDE_ccc_http_CookieBag_h
#define INCLUDE_ccc_http_CookieBag_h

#include <ccc/base/base.h>
#include <ccc/http/Cookie.h>
#include <ccc/base/LinkList.h>

CCC_NAMESPACE_START(CCC)

class Cookie;
class Uri;
class HttpResponse;
class HttpRequest;

/*!
 * UA側のクッキーデータを保持するクラスです。
 */
class CookieBag
{
  /*!
   * クッキーデータ
   */
  LinkList<Cookie> cookies;
 public:
  /*!
   * コンストラクタ
   */
  CookieBag();
  /*!
   * デストラクタ
   */
  ~CookieBag();
  /*!
   * 全てのクッキーを破棄します。
   */
  void clear();
  /*!
   * 賞味期限切れのクッキーを破棄します。
   */
  bool clearExpired();
  /*!
   * サーバから取得したクッキーをセットします。
   * \param uri URI
   * \param http_res サーバから取得したデータ
   * \retval true クッキーが存在しました。
   * \retval false クッキー-が存在しませんでした。
   */
  bool getCookie(const Uri* uri, const HttpResponse* http_res);
  /*!
   * HTTPリクエストにCookieをセットします。
   * \param uri URI
   * \param http_req サーバに送付するデータ
   * \retval true クッキーをセットしました。
   * \retval false クッキー-をセットしませんでした。
   */
  bool setCookie(const Uri* uri, HttpRequest* http_req);
};

CCC_NAMESPACE_END(CCC)

#endif /* INCLUDE_ccc_http_CookieBag_h */
