﻿// $Id$

#include <string.h>
#include <ccc/base/base.h>
#include <ccc/iceman/Iceman.h>
#include <ccc/http/HttpMessage.h>
#include <ccc/http/HttpHeaderLine.h>

#define USE_LOCAL_FMT

CCC_NAMESPACE_START(CCC)

HttpMessage::HttpMessage()
{
}

HttpMessage::~HttpMessage()
{
  HttpHeaderLine* hhl;
  while ((hhl = header_lines.pop()))
  {
    delete hhl;
  }
}

void
HttpMessage::add(BString* header_line)
{
  HttpHeaderLine* hhl = new HttpHeaderLine(header_line);
  header_lines.add(hhl);
}

void
HttpMessage::add(HttpHeaderLine* hhl)
{
  if (hhl->getFieldType() == HttpHeaderLine::FT_CONTINUE)
  {
    Iterator<HttpHeaderLine>* itr = header_lines.createIterator();
    HttpHeaderLine* prev = 0;
    HttpHeaderLine* x = 0;
    while ((x = itr->next()))
    {
      if ((x->getFieldType() != HttpHeaderLine::FT_CONTINUE) &&
	  (x->getFieldType() != HttpHeaderLine::FT_REQUEST_LINE) &&
	  (x->getFieldType() != HttpHeaderLine::FT_STATUS_LINE))
      {
	prev = x;
      }
    }
    delete itr;
    if (prev)
    {
      BString* prev_value2 = prev->getValue2();
      if (prev_value2)
      {
	prev_value2->add(*hhl->getValue2());
      }
    }
  }

  header_lines.add(hhl);
}

void
HttpMessage::insertTop(HttpHeaderLine* hhl)
{
  header_lines.push(hhl);
}

bool
HttpMessage::insertAfter(HttpHeaderLine* ref, HttpHeaderLine* hhl)
{
  return header_lines.insertAfter(ref, hhl);
}

bool
HttpMessage::textContentTypeP()
{
  HttpHeaderLine* hhl = getTypedHeaderLine(HttpHeaderLine::FT_CONTENT_TYPE);
  if (hhl == 0)
  {
    return false;	/* 判断できないのでバイナリ扱い */
  }
  BString* value = hhl->getFieldValue();
  if (value == 0)
  {
    return false;	/* 判断できないのでバイナリ扱い */
  }
  static const char* text_mime_type[] =
  {
    "text/plain",
    "text/html",
    "text/xml",
    "text/css",
    "text/javascript",
    "text/ecmascript",
    "application/xhtml+xml",
    "application/x-www-form-urlencoded",
    "application/javascript",
    "application/ecmascript",
    "application/json",
    0,
  };
  char* v = value->getCString();
  const char** x = text_mime_type;
  while (*x)
  {
    if (strncmp(v, *x, strlen(*x)) == 0)
    {
      return true;
    }
    x++;
  }
  return false;
}

CeId
HttpMessage::getContentTypeCharset()
{
  HttpHeaderLine* hhl = getTypedHeaderLine(HttpHeaderLine::FT_CONTENT_TYPE);
  if (hhl == 0)
  {
    return CEID_NULL;	/* 判断できないのでバイナリ扱い */
  }
  BString* value = hhl->getFieldValue();
  if (value == 0)
  {
    return CEID_NULL;	/* 判断できないのでバイナリ扱い */
  }
  char* v = value->getCString();
  /* ex.) Content-Type: text/html; charset=iso-8859-1 */
  char* x = strstr(v, "charset=");
  if (x == 0)
  {
    return CEID_NULL;
  }
  CeId ceid = Iceman::stringToCeId(x);
  return ceid;
}

void
HttpMessage::dump(TextWriter<Int8>* out)
{
  /* ヘッダ */
  OFlow* oflow = out->getDest();

  Iterator<HttpHeaderLine>* itr = header_lines.createIterator();
  HttpHeaderLine* x;
  while ((x = itr->next()))
  {
    BString* s = x->getHeaderLineString();
#ifdef USE_LOCAL_FMT
    oflow->put(s);
#else
    out->print(s);
#endif
    //x->dump(out);
  }
  delete itr;
#ifdef USE_LOCAL_FMT
  oflow->put("\r\n");
#else
  out->print("\r\n");
#endif
  /* ボディ */
  if (textContentTypeP())
  {
#ifdef USE_LOCAL_FMT
    Fmt8 fmt("# BODY TEXT: %u bytes\n");
    fmt.setUI(static_cast<unsigned int>(getBodySize()));
    fmt.writeTo(oflow);
#else
    out->printf("# BODY TEXT: %u bytes\n", getBodySize());
#endif
    CeId ceid = getContentTypeCharset();
    BString raw_body((char*)getBodyData(), getBodySize());
    if ((ceid != CEID_NULL) &&
	(ceid != CEID_UTF8N) &&
	(ceid != CEID_UTF8))
    {
      BString* utf8n_body = new BString();
      if (Iceman::convertToBString(ceid, CEID_UTF8N, &raw_body, utf8n_body))
      {
#ifdef USE_LOCAL_FMT
	oflow->put(utf8n_body);
#else
	out->print(utf8n_body);
#endif
      }
      delete utf8n_body;
    }
    else
    {
#ifdef USE_LOCAL_FMT
      oflow->put(&raw_body);
#else
      out->print(raw_body);
#endif
    }
#ifdef USE_LOCAL_FMT
    oflow->put("\n");
#else
    out->print("\n");
#endif
  }
  else
  {
    Size body_size = getBodySize();
#ifdef USE_LOCAL_FMT
    Fmt8 fmt("# BODY BINARY: %u bytes\n");
    fmt.setUI(static_cast<unsigned int>(body_size));
    fmt.writeTo(oflow);
#else
    out->printf("# BODY BINARY: %u bytes\n", body_size);
#endif
    char* v = (char*)getBodyData();
    Size n = 0;
    bool do_p = true;
    while (do_p)
    {
      for (int i = 0; i < 16; i++)
      {
	if (n++ >= body_size)
	{
	  do_p = false;
#ifdef USE_LOCAL_FMT
	  oflow->put("\n");
#else
	  out->print("\n");
#endif
	  break;
	}
#ifdef USE_LOCAL_FMT
	Fmt8 fmt("%02x ");
	fmt.setUI((unsigned int)*v++);
	fmt.writeTo(oflow);
#else
	out->printf("%02x ", *v++);
#endif
      }
#ifdef USE_LOCAL_FMT
      oflow->put("\n");
#else
      out->print("\n");
#endif
    }
  }
}

HttpHeaderLine*
HttpMessage::getTypedHeaderLine(HttpHeaderLine::FieldType ft)
{
  HttpHeaderLine* ret = 0;
  Iterator<HttpHeaderLine>* itr = header_lines.createIterator();
  HttpHeaderLine* x;
  while ((x = itr->next()))
  {
    if (x->getFieldType() == ft)
    {
      ret = x;
      break;
    }
  }
  delete itr;
  return ret;
}

void
HttpMessage::expandBody(Size size)
{
  body.expand(size);
  body.setUsedSize(size);
}

void*
HttpMessage::getBodyData()
{
  return body.getMem();
}

Size
HttpMessage::getBodySize()
{
  return body.getUsedSize();
}

Size
HttpMessage::getContentLength(bool& found_p)
{
  found_p = true;
  HttpHeaderLine* content_length = getTypedHeaderLine(HttpHeaderLine::FT_CONTENT_LENGTH);
  if (content_length == 0)
  {
    found_p = false;
    return 0;
  }
  BString* v = content_length->getFieldValue();
  if (v == 0)
  {
    found_p = false;
    return 0;
  }
  Size value = v->getUInt();
  return value;
}

Iterator<HttpHeaderLine>*
HttpMessage::makeHeaderLineIterator() const
{
  return header_lines.createIterator();
}

bool
HttpMessage::chunkedP()
{
  HttpHeaderLine* transfer_encoding_line = getTypedHeaderLine(HttpHeaderLine::FT_TRANSFER_ENCODING);
  if (transfer_encoding_line == 0)
  {
    return false;
  }
  BString* val = transfer_encoding_line->getValue2();
  if (val == 0)
  {
    return false;
  }
  if (val->strCmp("chunked") == 0)
  {
    return true;
  }
  return false;
}

CCC_NAMESPACE_END(CCC)
