﻿// $Id$

#ifndef INCLUDE_ccc_http_HttpMessage_h
#define INCLUDE_ccc_http_HttpMessage_h

#include <ccc/base/base.h>
#include <ccc/base/LinkList.h>
#include <ccc/base/Allocator.h>
#include <ccc/base/TString.h>
#include <ccc/base/TextWriter.h>
#include <ccc/iceman/Iceman.h>
#include <ccc/http/HttpHeaderLine.h>

CCC_NAMESPACE_START(CCC)

/*!
 * HttpRequest, HttpResponseのスーパクラスとしてHTTPの
 * 入出力プロトコルのデータを表現します。
 */
class HttpMessage
{
  LinkList<HttpHeaderLine> header_lines;	/* ヘッダー行のリスト */
  Allocator body;				/* ボディデータ */
 public:
  /*!
   * コンストラクタ
   */
  HttpMessage();
  /*!
   * デストラクタ
   * 内部に格納されたヘッダー行データ、ボディデータも破棄されます。
   */
  virtual ~HttpMessage();
  /*!
   * 新たなヘッダ行を追加します。
   * \param header_line 追加するヘッダ行
   */
  void add(BString* header_line);
  /*!
   * 新たなヘッダ行を追加します。
   * \param hhl 追加するヘッダ行
   */
  void add(HttpHeaderLine* hhl);
  /*!
   * 新たなヘッダ行を先頭に挿入します。
   * \param hhl 挿入するヘッダ行
   */
  void insertTop(HttpHeaderLine* hhl);
  /*!
   * 新たなヘッダ行を参照されたヘッダの直後に挿入します。
   * \param before_ref 参照ヘッダ位置
   * \param hhl 挿入するヘッダ行
   * \retval true 成功
   * \retval false 失敗
   */
  bool insertAfter(HttpHeaderLine* before_ref, HttpHeaderLine* hhl);
  /*!
   * ボディデータのバッファを指定サイズまで拡張します。
   * \param size バイト数
   */
  void expandBody(Size size);
  /*!
   * ボディデータを取得します。
   * \return データ
   */
  void* getBodyData();
  /*!
   * ボディデータのサイズを取得します。
   * \return データサイズ
   */
  Size getBodySize();
  /*!
   * ボディデータを取得します。
   * \return ボディデータ
   */
  Allocator* getBody() { return &body; }
  /*!
   * 特定のフィールドタイプのヘッダ行を取得します。
   * 複数同種のヘッダ行が存在する場合には、最初に見つかったものが返ります。
   * \return 該当ヘッダ行、存在しない場合には0が返ります。
   */
  HttpHeaderLine* getTypedHeaderLine(HttpHeaderLine::FieldType ft);
  /*!
   * Content-Lengthの数値を取得します。
   * \param found_p 数値を得られない場合はfalseがセットされます。
   * \return 数値
   */
  virtual Size getContentLength(bool& found_p);
  /*!
   * Content-Typeよりボディがテキスト形式かどうかを判断します。
   * \retval true テキスト形式	
   * \retval false バイナリ形式
   */
  bool textContentTypeP();
  /*!
   * Content-Type:よりボディのcharsetを求めます。
   * ex.)
   * Content-Type: text/html; charset=iso-8859-1
   * \return charset
   * \retval CEID_NULL 取得できない場合
   */
  CeId getContentTypeCharset();
  /*!
   * メッセージの内容を指定先に出力します。
   * \param out 出力先
   */
  void dump(TextWriter<Int8>* out);
  /*!
   * ヘッダ行のイタレータを生成します。
   * \return ヘッダ行のイタレータ
   */
  Iterator<HttpHeaderLine>* makeHeaderLineIterator() const;
  /*!
   * チャンク型式の指定があるかどうかをチェックします。
   * Transfer-Encoding: chunked
   */
  bool chunkedP();
};

CCC_NAMESPACE_END(CCC)

#endif /* INCLUDE_ccc_http_HttpMessage_h */
