﻿// $Id$

#include <ccc/base/base.h>
#include <ccc/http/HttpRequest.h>
#include <ccc/http/HttpHeaderLine.h>

CCC_NAMESPACE_START(CCC)

HttpRequest::HttpRequest()
{
  request_line = 0;
}

HttpRequest::~HttpRequest()
{
}

void
HttpRequest::addMethod(BString* request_line_)
{
  HttpHeaderLine* request_hhl = new HttpHeaderLine(request_line_, HttpHeaderLine::FT_REQUEST_LINE);
  add(request_hhl);
  request_line = request_hhl;
}

void
HttpRequest::addHeader(BString* header_line)
{
  HttpHeaderLine* hhl = new HttpHeaderLine(header_line);
  add(hhl);
}

bool
HttpRequest::keepAliveP()
{
  /* Content-Length: で長さが指定されていない場合は、コネクションの終わりまでを
   * ボディーのデータとして読み込まざるを得ません。*/
  bool found_p;
  /*Size size = */ getContentLength(found_p);
  if (!found_p)
  {
    return false;
  }
  
  /* "Connection: keep-alive"を調べます。*/
  HttpHeaderLine* connection = getTypedHeaderLine(HttpHeaderLine::FT_CONNECTION);
  if (connection)
  {
    if (connection->getFieldValue()->strCmp("close") == 0)
    {
      return false;
    }
    if (connection->getFieldValue()->strCmp("keep-alive") == 0)
    {
      return true;
    }
  }
  /* "HTTP/1.0 ならkeep-aliveでfalseを返すようにします。*/
  if (request_line)
  {
    BString* v = request_line->getHttpVersion();
    if (v && v->strCmp("HTTP/1.0") == 0)
    {
      return false;
    }
  }
  return true;
}

Size
HttpRequest::getContentLength(bool& found_p)
{
  if (request_line == 0)
  {
    found_p = false;
    return 0;
  }
  Size size = 0;
  HttpRequestMethod method = request_line->getRequestMethod();
  switch (method)
  {
   case RM_OPTIONS:
    size = HttpMessage::getContentLength(found_p);
    if (!found_p)
    {
      found_p = true;
    }
    break;
    
   case RM_GET:
   case RM_HEAD:
   case RM_DELETE:
   case RM_TRACE:
   case RM_CONNECT:
   case RM_UNKNOWN:
    found_p = true;
    size = 0;
    break;

   case RM_POST:
   case RM_PUT:
    size = HttpMessage::getContentLength(found_p);
    break;
  }
  return size;
}

HttpRequestMethod
HttpRequest::getRequestMethod()
{
  if (request_line)
  {
    return request_line->getRequestMethod();
  }
  return RM_UNKNOWN;
}

CCC_NAMESPACE_END(CCC)
