﻿// $Id$

#ifndef INCLUDE_ccc_http_HttpRequest_h
#define INCLUDE_ccc_http_HttpRequest_h

#include <ccc/base/base.h>
#include <ccc/http/HttpMessage.h>

CCC_NAMESPACE_START(CCC)

/*!
 * HTTPのリクエストを表現します。
 */
class HttpRequest
  : public HttpMessage
{
  /*!
   * リクエスト行
   */
  HttpHeaderLine* request_line;
 public:
  /*!
   * コンストラクタ
   */
  HttpRequest();
  /*!
   * デストラクタ
   */
  virtual ~HttpRequest();
  /*!
   * 新たなリクエストヘッダ行を追加します。
   * \param request_line 追加するリクエストヘッダ行
   */
  void addMethod(BString* request_line);
  /*!
   * 新たなヘッダ行を追加します。
   * \param header_line
   */
  void addHeader(BString* header_line);
  /*!	
   * セッションを保持するかどうかを返します。
   * \retval true 保持する
   * \retval false 保持しない
   */
  bool keepAliveP();
  /*!
   * Content-Lengthの数値を取得します。
   * \param found_p 数値を得られない場合はfalseがセットされます。
   * \return 数値
   */
  virtual Size getContentLength(bool& found_p);
  /*!
   * リクエストメソッドを取得します。
   * \return リクエストメソッド
   */
  HttpRequestMethod getRequestMethod();
  /*!
   * リクエスト行を取得します。
   * \return リクエスト行
   */
  HttpHeaderLine* getRequestLine() { return request_line; }
};

CCC_NAMESPACE_END(CCC)

#endif /* INCLUDE_ccc_http_HttpRequest_h */
