﻿// $Id$

#include <stdlib.h>
#include <ccc/base/base.h>
#include <ccc/http/HttpStatusCode.h>

CCC_NAMESPACE_START(CCC)

struct StatusCodeEntry
{
  int code;
  const char* reason;
};

static StatusCodeEntry status_codes[] = 
{
  { HttpStatusCode::HSC_100, "Continue" },
  { HttpStatusCode::HSC_101, "Switching Protocols" },
  { HttpStatusCode::HSC_200, "OK" },
  { HttpStatusCode::HSC_201, "Created" },
  { HttpStatusCode::HSC_202, "Accepted" },
  { HttpStatusCode::HSC_203, "Non-Authoritative Information" },
  { HttpStatusCode::HSC_204, "No Content" },
  { HttpStatusCode::HSC_205, "Reset Content" },
  { HttpStatusCode::HSC_206, "Partial Content" },
  { HttpStatusCode::HSC_300, "Multiple Choices" },
  { HttpStatusCode::HSC_301, "Moved Permanently" },
  { HttpStatusCode::HSC_302, "Found" },
  { HttpStatusCode::HSC_303, "See Other" },
  { HttpStatusCode::HSC_304, "Not Modified" },
  { HttpStatusCode::HSC_305, "Use Proxy" },
  { HttpStatusCode::HSC_307, "Temporary Redirect" },
  { HttpStatusCode::HSC_400, "Bad Request" },
  { HttpStatusCode::HSC_401, "Unauthorized" },
  { HttpStatusCode::HSC_402, "Payment Required" },
  { HttpStatusCode::HSC_403, "Forbidden" },
  { HttpStatusCode::HSC_404, "Not Found" },
  { HttpStatusCode::HSC_405, "Method Not Allowed" },
  { HttpStatusCode::HSC_406, "Not Acceptable" },
  { HttpStatusCode::HSC_407, "Proxy Authentication Required" },
  { HttpStatusCode::HSC_408, "Request Time-out" },
  { HttpStatusCode::HSC_409, "Conflict" },
  { HttpStatusCode::HSC_410, "Gone" },
  { HttpStatusCode::HSC_411, "Length Required" },
  { HttpStatusCode::HSC_412, "Precondition Failed" },
  { HttpStatusCode::HSC_413, "Request Entity Too Large" },
  { HttpStatusCode::HSC_414, "Request-URI Too Large" },
  { HttpStatusCode::HSC_415, "Unsupported Media Type" },
  { HttpStatusCode::HSC_416, "Requested range not satisfiable" },
  { HttpStatusCode::HSC_417, "Expectation Failed" },
  { HttpStatusCode::HSC_500, "Internal Server Error" },
  { HttpStatusCode::HSC_501, "Not Implemented" },
  { HttpStatusCode::HSC_502, "Bad Gateway" },
  { HttpStatusCode::HSC_503, "Service Unavailable" },
  { HttpStatusCode::HSC_504, "Gateway Time-out" },
  { HttpStatusCode::HSC_505, "HTTP Version not supported" },
  { HttpStatusCode::HSC_UNDEFINDED, 0 },
};

int
HttpStatusCode::getStatusCode(char* str)
{
  int num = atoi(str);
  StatusCodeEntry* e = status_codes;
  while (e->reason)
  {
    if (e->code == num)
    {
      return num;
    }
    e++;
  }
  return HttpStatusCode::HSC_UNDEFINDED;
}

const char*
HttpStatusCode::getReasonPhase(int status_code)
{
  StatusCodeEntry* e = status_codes;
  while (e->reason)
  {
    if (e->code == status_code)
    {
      return e->reason;
    }
    e++;
  }
  return 0;
}

CCC_NAMESPACE_END(CCC)
