﻿// $Id$

#ifndef INCLUDE_ccc_http_HttpStatusCode_h
#define INCLUDE_ccc_http_HttpStatusCode_h

#include <ccc/base/base.h>

CCC_NAMESPACE_START(CCC)

/*!
 * HTTPのステータスコードを処理します。
 */
class HttpStatusCode
{
 public:
  enum
  {
    HSC_100 = 100, /* Continue */
    HSC_101 = 101, /* Switching Protocols */
    HSC_200 = 200, /* OK */
    HSC_201 = 201, /* Created */
    HSC_202 = 202, /* Accepted */
    HSC_203 = 203, /* Non-Authoritative Information */
    HSC_204 = 204, /* No Content */
    HSC_205 = 205, /* Reset Content */
    HSC_206 = 206, /* Partial Content */
    HSC_300 = 300, /* Multiple Choices */
    HSC_301 = 301, /* Moved Permanently */
    HSC_302 = 302, /* Found */
    HSC_303 = 303, /* See Other */
    HSC_304 = 304, /* Not Modified */
    HSC_305 = 305, /* Use Proxy */
    HSC_307 = 307, /* Temporary Redirect */
    HSC_400 = 400, /* Bad Request */
    HSC_401 = 401, /* Unauthorized */
    HSC_402 = 402, /* Payment Required */
    HSC_403 = 403, /* Forbidden */
    HSC_404 = 404, /* Not Found */
    HSC_405 = 405, /* Method Not Allowed */
    HSC_406 = 406, /* Not Acceptable */
    HSC_407 = 407, /* Proxy Authentication Required */
    HSC_408 = 408, /* Request Time-out */
    HSC_409 = 409, /* Conflict */
    HSC_410 = 410, /* Gone */
    HSC_411 = 411, /* Length Required */
    HSC_412 = 412, /* Precondition Failed */
    HSC_413 = 413, /* Request Entity Too Large */
    HSC_414 = 414, /* Request-URI Too Large */
    HSC_415 = 415, /* Unsupported Media Type */
    HSC_416 = 416, /* Requested range not satisfiable */
    HSC_417 = 417, /* Expectation Failed */
    HSC_500 = 500, /* Internal Server Error */
    HSC_501 = 501, /* Not Implemented */
    HSC_502 = 502, /* Bad Gateway */
    HSC_503 = 503, /* Service Unavailable */
    HSC_504 = 504, /* Gateway Time-out */
    HSC_505 = 505, /* HTTP Version not supported */
    HSC_UNDEFINDED = 0,	/* 未定義 */
  };
  /*!
   * ステータスコードの文字列からStatusCode値を取得します。
   * 未定義の場合には、HSC_UNDEFINDEDの値が返ります。
   * \param str 文字列
   * \return StatusCode値
   */
  static int getStatusCode(char* str);
  /*!
   * ステータスコードより、説明文字列を取得します。
   * 未定義のステータスコードの場合には、0が返ります。
   * \param status_code ステータスコード
   * \return 説明文字列
   */
  static const char* getReasonPhase(int status_code);
};

CCC_NAMESPACE_END(CCC)

#endif /* INCLUDE_ccc_http_HttpStatusCode_h */
