﻿// $Id$

#include <assert.h>
#include <ccc/iceman/Base64.h>
#include <ccc/iceman/Iceman.h>
#include <ccc/iceman/Unicode.h>

CCC_NAMESPACE_START(CCC);

// ============================================================
// ub64 table
static char ub64[256] =
{
    0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,  62,   0,   0,   0,  63,
   52,  53,  54,  55,  56,  57,  58,  59,
   60,  61,   0,   0,   0,   0,   0,   0,
    0,   0,   1,   2,   3,   4,   5,   6,
    7,   8,   9,  10,  11,  12,  13,  14,
   15,  16,  17,  18,  19,  20,  21,  22,
   23,  24,  25,   0,   0,   0,   0,   0,
    0,  26,  27,  28,  29,  30,  31,  32,
   33,  34,  35,  36,  37,  38,  39,  40,
   41,  42,  43,  44,  45,  46,  47,  48,
   49,  50,  51,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,
};

// This ub64 table was generated by following code.
#if 0
// generate ub64 table
#include <stdio.h>
static char ub64[256];
void
init_ub64table()
{
  static char b64[64] =
  {
    'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H',
    'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P',
    'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X',
    'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 
    'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 
    'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 
    'w', 'x', 'y', 'z', '0', '1', '2', '3', 
    '4', '5', '6', '7', '8', '9', '+', '/',
  };
  for (int i = 0; i < 256; i++)
  {
    int idx = 0;
    for (int j = 0; j < 64; j++)
    {
      if (b64[j] == i)
      {
	idx = j;
	break;
      }
    }
    ub64[i] = idx;
  }
  ub64['='] = 0;
}

int
main()
{
  init_ub64table();
  printf("// ub64 table\n");
  printf("static char ub64[256] =\n");
  printf("{\n  ");
  for (int i = 0; i < 256; i++)
  {
    printf("%3i", ub64[i]);
    if ((i + 1) % 8 == 0 && i != 0)
    {
      printf(",");
      if (i != 255)
      {
	printf("\n  ");
      }
    }
    else
    {
      printf(", ");
    }
  }
  printf("\n};\n");
}
#endif /* 0 */ 
// ============================================================

Size
Base64::decode(const UInt8* in, UInt8* out)
{
  UInt8 c1 = ub64[in[0]];
  UInt8 c2 = ub64[in[1]];
  UInt8 c3 = ub64[in[2]];
  UInt8 c4 = ub64[in[3]];
  out[0] = (c1 << 2) | (c2 >> 4);
  if (in[2] == '=')
  {
    out[1] = 0;
    out[2] = 0;
    return 1;
  }
  out[1] = (c2 << 4) | (c3 >> 2);
  if (in[3] == '=')
  {
    out[2] = 0;
    return 2;
  }
  out[2] = (c3 << 6) | c4;
  return 3;
}

Size
Base64::decodeModified(const UInt8* in, Size in_len, UInt8* out)
{
  UInt8 c1 = ub64[in[0]];
  UInt8 c2 = ub64[in[1]];
  UInt8 c3 = ub64[in[2]];
  UInt8 c4 = ub64[in[3]];
  switch (in_len)
  {
   case 0:
    out[0] = 0;
    out[1] = 0;
    out[2] = 0;
    return 0;

   case 1:
    out[0] = (c1 << 2);
    out[1] = 0;
    out[2] = 0;
    return 0;
    
   case 2:
    out[0] = (c1 << 2) | (c2 >> 4);
    out[1] = (c2 << 4);
    out[2] = 0;
    return 1;

   case 3:
    out[0] = (c1 << 2) | (c2 >> 4);
    out[1] = (c2 << 4) | (c3 >> 2);
    out[2] = (c3 << 6);
    return 2;

   case 4:
    out[0] = (c1 << 2) | (c2 >> 4);
    out[1] = (c2 << 4) | (c3 >> 2);
    out[2] = (c3 << 6) | c4;
    return 3;
  }
  assert(false);
  return 0;
}

static char b64[64] =
{
//+0   +1   +2   +3   +4   +5   +6   +7   +8   +9   +a   +b   +c   +d   +e   +f
  'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P',
  'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 
  'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 
  'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/',
};

Size
Base64::encode(const UInt8* in, Size in_len, UInt8* out)
{
  // bit 7  6  5  4  3  2  1  0
  // c1 [1][1][1][1][1][1][2][2]
  // c2 [2][2][2][2][3][3][3][3]
  // c3 [3][3][4][4][4][4][4][4]

  switch (in_len)
  {
   case 1:
    // c1 [1][1][1][1][1][1][-][-]
    out[0] = b64[in[0] >> 2];
    // c1 [-][-][-][-][-][-][2][2]
    // c2 [2][2][2][2][-][-][-][-]
    out[1] = b64[(in[0] & 0x03) << 4];
    out[2] = '=';
    out[3] = '=';
    break;

   case 2:
    // c1 [1][1][1][1][1][1][-][-]
    out[0] = b64[in[0] >> 2];
    // c1 [-][-][-][-][-][-][2][2]
    // c2 [2][2][2][2][-][-][-][-]
    out[1] = b64[((in[0] & 0x03) << 4) | ((in[1] & 0xf0) >> 4)];
    // c2 [-][-][-][-][3][3][3][3]
    // c3 [3][3][-][-][-][-][-][-]
    out[2] = b64[(in[1] & 0x0f) << 2];
    out[3] = '=';
    break;

   case 3:
    // c1 [1][1][1][1][1][1][-][-]
    out[0] = b64[in[0] >> 2];
    // c1 [-][-][-][-][-][-][2][2]
    // c2 [2][2][2][2][-][-][-][-]
    out[1] = b64[((in[0] & 0x03) << 4) | ((in[1] & 0xf0) >> 4)];
    // c2 [-][-][-][-][3][3][3][3]
    // c3 [3][3][-][-][-][-][-][-]
    out[2] = b64[((in[1] & 0x0f) << 2) | ((in[2] & 0xc0) >> 6)];
    // c3 [-][-][4][4][4][4][4][4]
    out[3] = b64[(in[2] & 0x3f)];
    break;

   default:
    assert(false);
    break;
  }
  return 4;
}

Size
Base64::encodeModified(const UInt8* in, Size in_len, UInt8* out)
{
  // bit 7  6  5  4  3  2  1  0
  // c1 [1][1][1][1][1][1][2][2]
  // c2 [2][2][2][2][3][3][3][3]
  // c3 [3][3][4][4][4][4][4][4]

  int ret = 0;
  switch (in_len)
  {
   case 1:
    // c1 [1][1][1][1][1][1][-][-]
    out[0] = b64[in[0] >> 2];
    // c1 [-][-][-][-][-][-][2][2]
    // c2 [2][2][2][2][-][-][-][-]
    out[1] = b64[(in[0] & 0x03) << 4];
    // out[2] = '=';
    // out[3] = '=';
    ret = 2;
    break;

   case 2:
    // c1 [1][1][1][1][1][1][-][-]
    out[0] = b64[in[0] >> 2];
    // c1 [-][-][-][-][-][-][2][2]
    // c2 [2][2][2][2][-][-][-][-]
    out[1] = b64[((in[0] & 0x03) << 4) | ((in[1] & 0xf0) >> 4)];
    // c2 [-][-][-][-][3][3][3][3]
    // c3 [3][3][-][-][-][-][-][-]
    out[2] = b64[(in[1] & 0x0f) << 2];
    // out[3] = '=';
    ret = 3;
    break;

   case 3:
    // c1 [1][1][1][1][1][1][-][-]
    out[0] = b64[in[0] >> 2];
    // c1 [-][-][-][-][-][-][2][2]
    // c2 [2][2][2][2][-][-][-][-]
    out[1] = b64[((in[0] & 0x03) << 4) | ((in[1] & 0xf0) >> 4)];
    // c2 [-][-][-][-][3][3][3][3]
    // c3 [3][3][-][-][-][-][-][-]
    out[2] = b64[((in[1] & 0x0f) << 2) | ((in[2] & 0xc0) >> 6)];
    // c3 [-][-][4][4][4][4][4][4]
    out[3] = b64[(in[2] & 0x3f)];
    ret = 4;
    break;

   default:
    assert(false);
    break;
  }
  return ret;
}

Size
Base64::encode(const UInt8* in, Size in_len, BString* out)
{
  out->clear();
  Size n;
  const UInt8* x = in;
  for (n = 0; n < in_len; n += 3)
  {
    Size len = 3;
    if (n + 3 > in_len)
    {
      len = in_len - n;
    }
    UInt8 o[5];
    encode(x, len, o);
    o[4] = '\0';
    out->add((char*)o);
    x += 3;
  }
  return out->getLength();
}

Size
Base64::decode(const CCC::BString* in, Allocator* out)
{
  return decode((const UInt8*)in->getStartPtr(), in->getLength(), out);
}

Size
Base64::decode(const UInt8* in, Size in_len, Allocator* out)
{
  out->setUsedSize(0);
  Size out_size = 0;
  Size n;
  const UInt8* x = in;
  for (n = 0; n < in_len; n += 4)
  {
    // in: 4bytes out:3 bytes
    UInt8 o[3];
    Size m = decode(x, o);
    out->addUsedSize(m);
    UInt8* mem = (UInt8*)out->getMem();
    Size l;
    for (l = 0; l < m; l++)
    {
      mem[out_size + l] = o[l];
    }
    out_size += m;
    x += 4;
  }
  return out_size;
}

CCC_NAMESPACE_END(CCC);
