﻿// -*- coding: utf-8 -*-
// $Id$

#ifndef INCLUDE_ccc_iceman_Base64_h
#define INCLUDE_ccc_iceman_Base64_h

#include <ccc/base/base.h>
#include <ccc/base/TString.h>
#include <ccc/base/Allocator.h>

CCC_NAMESPACE_START(CCC);

class Base64
{
 public:
  /*!
   * BASE64でエンコードします。
   * \param in エンコード対象のデータ
   * \param in_len 長さ
   * \param out 出力先
   * \return エンコードしたバイト数が返ります
   */
  static Size encode(const UInt8* in, Size in_len, BString* out);
  /*!
   * BASE64の1ユニットをエンコードします。
   * encode BASE64
   * \param in: 3 bytes 変換元
   * \param out: 4 bytes 変換先
   * \return 常にエンコードしたバイト数4が返ります. (パディングとして=がセットされます)
   */
  static Size encode(const UInt8* in, Size in_len, UInt8* out);
  /*!
   * BASE64の1ユニットをエンコードします。
   * for UTF7 encode
   * \param in: 変換元
   * \param in_len: 変換元の長さ
   * \param out: 4 bytes 変換先
   * \return エンコードしたバイト数が返ります
   */
  static Size encodeModified(const UInt8* in, Size in_len, UInt8* out);
  /*!
   * BASE64をデコードします。
   * \param in デコード対象のデータ
   * \param out 出力先
   * \param デコードしたバイト数が返ります。
   */
  static Size decode(const CCC::BString* in, Allocator* out);
  /*!
   * BASE64をデコードします。
   * \param in デコード対象のデータ
   * \param in_len デコード対象データの長さ
   * \param out 出力先
   * \param デコードしたバイト数が返ります。
   */
  static Size decode(const UInt8* in, Size in_len, Allocator* out);
  /*!
   * BASE64の1ユニットをデコードします。
   * decode BASE64
   * \param in: 4 bytes 変換元
   * \param out: 3 bytes 変換先
   * \param デコードしたバイト数が返ります。
   */
  static Size decode(const UInt8* in, UInt8* out);
  /*!
   * BASE64の1ユニットをデコードします。
   * for UTF7 decode
   * \param in: 変換元
   * \param in_len: 変換元の長さ
   * \param out: 3 bytes 変換先
   * \return デコードしたバイト数が返ります
   */
  static Size decodeModified(const UInt8* in, Size in_len, UInt8* out);
};

CCC_NAMESPACE_END(CCC);

#endif /* INCLUDE_ccc_iceman_Base64_h */
