﻿// @@DISTHDR@@
// $Id$

#include <assert.h>
#include <string.h>
#include <ccc/iceman/CenDictionary.h>

CCC_NAMESPACE_START(CCC);

struct CenDictionaryEntry
{
  CeId id;
  const char* name;

 public:
  CeId getCeId() const { return id; }
  const char* getName() const { return name; }
};

CenDictionaryEntry entries[] = 
{
#define CCC_ICEMAN_CEDIC_DEF
#include <ccc/iceman/ces.h>
#undef CCC_ICEMAN_CEDIC_DEF
  { CEID_NULL, 0 }
};

CenDictionary* CenDictionary::cen = 0;

CenDictionary::CenDictionary()
{
}

CenDictionary::~CenDictionary()
{
}

const char*
CenDictionary::getKey(const CenDictionaryEntry* element) const
{
  return element->getName();
}

int
CenDictionary::compare(const char* key1, const char* key2) const
{
  return strcasecmp(key1, key2);
}

void
CenDictionary::initialize()
{
  cen = new CenDictionary();
  CenDictionaryEntry* p = entries;
  while (p->getCeId() != CEID_NULL)
  {
    cen->add(p);
    p++;
  }
}

void
CenDictionary::unInitialize()
{
  delete cen;
}

CeId
CenDictionary::searchId(const char* name)
{
  assert(cen != 0);
  CenDictionaryEntry* entry = cen->search(name);
  if (entry)
  {
    return entry->getCeId();
  }
  return CEID_NULL;
}

const char*
CenDictionary::searchStr(CeId id)
{
  CenDictionaryEntry* p = entries;
  while (p->getCeId() != CEID_NULL)
  {
    if (p->getCeId() == id)
    {
      return p->getName();
    }
    p++;
  }
  return 0;
}

CCC_NAMESPACE_END(CCC);
