﻿// $Id$

#include <ctype.h>
#include <ccc/iceman/DecodeUrl.h>
#include <ccc/base/StringIFlow.h>
#include <ccc/base/StringOFlow.h>
#include <ccc/base/Conveyer.h>

CCC_NAMESPACE_START(CCC);

DecodeUrl::DecodeUrl()
{
}

DecodeUrl::~DecodeUrl()
{
}

static char
charValue(char c)
{
  if (('0' <= c) && (c <= '9'))
  {
    return c - '0';
  }
  else if (('A' <= c) && (c <= 'F'))
  {
    return c - 'A' + 10;
  }
  else if (('a' <= c) && (c <= 'f'))
  {
    return c - 'a' + 10;
  }
  return 0;
}

Int8
DecodeUrl::getInt8() CCC_RAISES(IOException)
{
  if (getQueueLength())
  {
    Int8 ret = pop();
    return ret;
  }
  UInt8 c = (UInt8)src->getInt8();
  if (c == '+')
  {
    return ' ';
  }
  else if (c == '%')
  {
    c = (UInt8)src->getInt8();
    UInt8 v = charValue(c);
    c = (UInt8)src->getInt8();
    v = v * 16 + charValue(c);
    return (Int8)v;
  }
  else
  {
    return (Int8)c;
  }
}

IFilter* 
DecodeUrl::createIFilter()
{
  return new DecodeUrl();
}

void
DecodeUrl::decode(const BString* src, BString* result)
{
  BStringIFlow iflow(src);
  DecodeUrl decoder;
  decoder.setSrc(&iflow);
  BStringOFlow oflow(result);
  Conveyer conv(&decoder, &oflow);
  try
  {
    conv.carry(IOTYPE_INT8);
  }
  catch (IOException /* ioe */)
  {
  }
}

CCC_NAMESPACE_END(CCC);
